/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.snapshots.get;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.easysearch.action.ActionResponse;
import org.easysearch.common.ParseField;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.snapshots.SnapshotInfo;

public class GetSnapshotsResponse
extends ActionResponse
implements ToXContentObject {
    private static final ConstructingObjectParser<GetSnapshotsResponse, Void> GET_SNAPSHOT_PARSER = new ConstructingObjectParser(GetSnapshotsResponse.class.getName(), true, args -> new GetSnapshotsResponse((List)args[0]));
    private final List<SnapshotInfo> snapshots;

    public GetSnapshotsResponse(List<SnapshotInfo> snapshots) {
        this.snapshots = Collections.unmodifiableList(snapshots);
    }

    GetSnapshotsResponse(StreamInput in) throws IOException {
        super(in);
        this.snapshots = Collections.unmodifiableList(in.readList(SnapshotInfo::new));
    }

    public List<SnapshotInfo> getSnapshots() {
        return this.snapshots;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.snapshots);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("snapshots");
        for (SnapshotInfo snapshotInfo : this.snapshots) {
            snapshotInfo.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static GetSnapshotsResponse fromXContent(XContentParser parser) throws IOException {
        return GET_SNAPSHOT_PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSnapshotsResponse that = (GetSnapshotsResponse)o;
        return Objects.equals(this.snapshots, that.snapshots);
    }

    public int hashCode() {
        return Objects.hash(this.snapshots);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        GET_SNAPSHOT_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> SnapshotInfo.SNAPSHOT_INFO_PARSER.apply(p, (Void)c).build(), new ParseField("snapshots", new String[0]));
    }
}

