/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.node.tasks.get;

import java.io.IOException;
import org.easysearch.EasysearchException;
import org.easysearch.ExceptionsHelper;
import org.easysearch.ResourceNotFoundException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.ActionListenerResponseHandler;
import org.easysearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.easysearch.action.admin.cluster.node.tasks.get.GetTaskResponse;
import org.easysearch.action.admin.cluster.node.tasks.list.TransportListTasksAction;
import org.easysearch.action.get.GetRequest;
import org.easysearch.action.get.GetResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.HandledTransportAction;
import org.easysearch.client.Client;
import org.easysearch.client.OriginSettingClient;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.util.concurrent.AbstractRunnable;
import org.easysearch.common.xcontent.LoggingDeprecationHandler;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.common.xcontent.XContentHelper;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.IndexNotFoundException;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskInfo;
import org.easysearch.tasks.TaskResult;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportRequest;
import org.easysearch.transport.TransportRequestOptions;
import org.easysearch.transport.TransportService;

public class TransportGetTaskAction
extends HandledTransportAction<GetTaskRequest, GetTaskResponse> {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportGetTaskAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:monitor/task/get", transportService, actionFilters, GetTaskRequest::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.client = new OriginSettingClient(client, "tasks");
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    protected void doExecute(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        if (this.clusterService.localNode().getId().equals(request.getTaskId().getNodeId())) {
            this.getRunningTaskFromNode(thisTask, request, listener);
        } else {
            this.runOnNodeWithTaskIfPossible(thisTask, request, listener);
        }
    }

    private void runOnNodeWithTaskIfPossible(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        DiscoveryNode node;
        TransportRequestOptions.Builder builder = TransportRequestOptions.builder();
        if (request.getTimeout() != null) {
            builder.withTimeout(request.getTimeout());
        }
        if ((node = this.clusterService.state().nodes().get(request.getTaskId().getNodeId())) == null) {
            this.getFinishedTaskFromIndex(thisTask, request, ActionListener.wrap(listener::onResponse, e -> {
                if (e instanceof ResourceNotFoundException) {
                    e = new ResourceNotFoundException("task [" + request.getTaskId() + "] belongs to the node [" + request.getTaskId().getNodeId() + "] which isn't part of the cluster and there is no record of the task", (Throwable)e, new Object[0]);
                }
                listener.onFailure((Exception)e);
            }));
            return;
        }
        GetTaskRequest nodeRequest = request.nodeRequest(this.clusterService.localNode().getId(), thisTask.getId());
        this.transportService.sendRequest(node, "cluster:monitor/task/get", (TransportRequest)nodeRequest, builder.build(), new ActionListenerResponseHandler<GetTaskResponse>(listener, GetTaskResponse::new, "same"));
    }

    void getRunningTaskFromNode(final Task thisTask, final GetTaskRequest request, final ActionListener<GetTaskResponse> listener) {
        final Task runningTask = this.taskManager.getTask(request.getTaskId().getId());
        if (runningTask == null) {
            this.getFinishedTaskFromIndex(thisTask, request, listener);
        } else if (request.getWaitForCompletion()) {
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                protected void doRun() {
                    TransportGetTaskAction.this.taskManager.waitForTaskCompletion(runningTask, TransportListTasksAction.waitForCompletionTimeout(request.getTimeout()));
                    TransportGetTaskAction.this.waitedForCompletion(thisTask, request, runningTask.taskInfo(TransportGetTaskAction.this.clusterService.localNode().getId(), true), listener);
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            TaskInfo info = runningTask.taskInfo(this.clusterService.localNode().getId(), true);
            listener.onResponse(new GetTaskResponse(new TaskResult(false, info)));
        }
    }

    void waitedForCompletion(Task thisTask, GetTaskRequest request, TaskInfo snapshotOfRunningTask, ActionListener<GetTaskResponse> listener) {
        this.getFinishedTaskFromIndex(thisTask, request, ActionListener.delegateResponse(listener, (delegatedListener, e) -> {
            if (ExceptionsHelper.unwrap(e, ResourceNotFoundException.class) != null) {
                delegatedListener.onResponse(new GetTaskResponse(new TaskResult(true, snapshotOfRunningTask)));
            } else {
                delegatedListener.onFailure((Exception)e);
            }
        }));
    }

    void getFinishedTaskFromIndex(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        GetRequest get = new GetRequest(".tasks", "task", request.getTaskId().toString());
        get.setParentTask(this.clusterService.localNode().getId(), thisTask.getId());
        this.client.get(get, ActionListener.wrap(r -> this.onGetFinishedTaskFromIndex((GetResponse)r, listener), e -> {
            if (ExceptionsHelper.unwrap(e, IndexNotFoundException.class) != null) {
                listener.onFailure(new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", (Throwable)e, request.getTaskId()));
            } else {
                listener.onFailure((Exception)e);
            }
        }));
    }

    void onGetFinishedTaskFromIndex(GetResponse response, ActionListener<GetTaskResponse> listener) throws IOException {
        if (!response.isExists()) {
            listener.onFailure(new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", response.getId()));
            return;
        }
        if (response.isSourceEmpty()) {
            listener.onFailure(new EasysearchException("Stored task status for [{}] didn't contain any source!", response.getId()));
            return;
        }
        try (XContentParser parser = XContentHelper.createParser(this.xContentRegistry, LoggingDeprecationHandler.INSTANCE, response.getSourceAsBytesRef());){
            TaskResult result = TaskResult.PARSER.apply(parser, null);
            listener.onResponse(new GetTaskResponse(result));
        }
    }
}

