/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.easysearch.action.FailedNodeException;
import org.easysearch.action.admin.cluster.node.info.NodeInfo;
import org.easysearch.action.admin.cluster.node.info.PluginsAndModules;
import org.easysearch.action.support.nodes.BaseNodesResponse;
import org.easysearch.cluster.ClusterName;
import org.easysearch.cluster.node.DiscoveryNodeRole;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentFragment;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentFactory;
import org.easysearch.http.HttpInfo;
import org.easysearch.ingest.IngestInfo;
import org.easysearch.monitor.jvm.JvmInfo;
import org.easysearch.monitor.os.OsInfo;
import org.easysearch.monitor.process.ProcessInfo;
import org.easysearch.search.aggregations.support.AggregationInfo;
import org.easysearch.threadpool.ThreadPoolInfo;
import org.easysearch.transport.TransportInfo;

public class NodesInfoResponse
extends BaseNodesResponse<NodeInfo>
implements ToXContentFragment {
    public NodesInfoResponse(StreamInput in) throws IOException {
        super(in);
    }

    public NodesInfoResponse(ClusterName clusterName, List<NodeInfo> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    @Override
    protected List<NodeInfo> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(NodeInfo::new);
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<NodeInfo> nodes) throws IOException {
        out.writeList(nodes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (NodeInfo nodeInfo : this.getNodes()) {
            builder.startObject(nodeInfo.getNode().getId());
            builder.field("name", nodeInfo.getNode().getName());
            builder.field("transport_address", nodeInfo.getNode().getAddress().toString());
            builder.field("host", nodeInfo.getNode().getHostName());
            builder.field("ip", nodeInfo.getNode().getHostAddress());
            builder.field("version", nodeInfo.getVersion());
            builder.field("build_flavor", nodeInfo.getBuild().flavor().displayName());
            builder.field("build_type", nodeInfo.getBuild().type().displayName());
            builder.field("build_hash", nodeInfo.getBuild().hash());
            if (nodeInfo.getTotalIndexingBuffer() != null) {
                builder.humanReadableField("total_indexing_buffer", "total_indexing_buffer_in_bytes", nodeInfo.getTotalIndexingBuffer());
            }
            builder.startArray("roles");
            for (DiscoveryNodeRole discoveryNodeRole : nodeInfo.getNode().getRoles()) {
                builder.value(discoveryNodeRole.roleName());
            }
            builder.endArray();
            if (!nodeInfo.getNode().getAttributes().isEmpty()) {
                builder.startObject("attributes");
                for (Map.Entry entry : nodeInfo.getNode().getAttributes().entrySet()) {
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
            }
            if (nodeInfo.getSettings() != null) {
                builder.startObject("settings");
                Settings settings = nodeInfo.getSettings();
                settings.toXContent(builder, params);
                builder.endObject();
            }
            if (nodeInfo.getInfo(OsInfo.class) != null) {
                nodeInfo.getInfo(OsInfo.class).toXContent(builder, params);
            }
            if (nodeInfo.getInfo(ProcessInfo.class) != null) {
                nodeInfo.getInfo(ProcessInfo.class).toXContent(builder, params);
            }
            if (nodeInfo.getInfo(JvmInfo.class) != null) {
                nodeInfo.getInfo(JvmInfo.class).toXContent(builder, params);
            }
            if (nodeInfo.getInfo(ThreadPoolInfo.class) != null) {
                nodeInfo.getInfo(ThreadPoolInfo.class).toXContent(builder, params);
            }
            if (nodeInfo.getInfo(TransportInfo.class) != null) {
                nodeInfo.getInfo(TransportInfo.class).toXContent(builder, params);
            }
            if (nodeInfo.getInfo(HttpInfo.class) != null) {
                nodeInfo.getInfo(HttpInfo.class).toXContent(builder, params);
            }
            if (nodeInfo.getInfo(PluginsAndModules.class) != null) {
                nodeInfo.getInfo(PluginsAndModules.class).toXContent(builder, params);
            }
            if (nodeInfo.getInfo(IngestInfo.class) != null) {
                nodeInfo.getInfo(IngestInfo.class).toXContent(builder, params);
            }
            if (nodeInfo.getInfo(AggregationInfo.class) != null) {
                nodeInfo.getInfo(AggregationInfo.class).toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return Strings.toString(builder);
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }
}

