/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action;

import java.io.IOException;
import org.easysearch.EasysearchException;
import org.easysearch.common.Nullable;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.index.shard.ShardId;
import org.easysearch.rest.RestStatus;

public class UnavailableShardsException
extends EasysearchException {
    public UnavailableShardsException(@Nullable ShardId shardId, String message, Object ... args) {
        super(UnavailableShardsException.buildMessage(shardId, message), args);
    }

    public UnavailableShardsException(String index, int shardId, String message, Object ... args) {
        super(UnavailableShardsException.buildMessage(index, shardId, message), args);
    }

    private static String buildMessage(ShardId shardId, String message) {
        if (shardId == null) {
            return message;
        }
        return UnavailableShardsException.buildMessage(shardId.getIndexName(), shardId.id(), message);
    }

    private static String buildMessage(String index, int shardId, String message) {
        return "[" + index + "][" + shardId + "] " + message;
    }

    public UnavailableShardsException(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public RestStatus status() {
        return RestStatus.SERVICE_UNAVAILABLE;
    }
}

