/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.easysearch.Build;
import org.easysearch.CompatibleESVersion;
import org.easysearch.cluster.metadata.IndexMetadata;
import org.easysearch.common.Strings;
import org.easysearch.common.SuppressForbidden;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentFragment;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.monitor.jvm.JvmInfo;

public class Version
implements Comparable<Version>,
ToXContentFragment {
    public static final int V_EMPTY_ID = 0;
    public static final Version V_EMPTY = new Version(0, org.apache.lucene.util.Version.LATEST);
    public static final Version V_1_0_0 = new Version(1000099, org.apache.lucene.util.Version.LUCENE_8_7_0);
    public static final Version V_1_1_0 = new Version(1010099, org.apache.lucene.util.Version.LUCENE_8_11_2);
    public static final Version V_1_1_1 = new Version(1010199, org.apache.lucene.util.Version.LUCENE_8_11_2);
    public static final Version V_1_2_0 = new Version(1020099, org.apache.lucene.util.Version.LUCENE_8_11_2);
    public static final Version V_1_3_0 = new Version(1030099, org.apache.lucene.util.Version.LUCENE_8_11_2);
    public static final Version V_1_4_0 = new Version(1040099, org.apache.lucene.util.Version.LUCENE_8_11_2);
    public static final Version V_1_5_0 = new Version(1050099, org.apache.lucene.util.Version.LUCENE_8_11_2);
    public static final Version V_1_6_0 = new Version(1060099, org.apache.lucene.util.Version.LUCENE_8_11_2);
    public static final Version V_1_6_1 = new Version(1060199, org.apache.lucene.util.Version.LUCENE_8_11_2);
    public static final Version V_1_7_0 = new Version(1070099, org.apache.lucene.util.Version.LUCENE_8_11_2);
    public static final Version CURRENT = V_1_6_1;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final org.apache.lucene.util.Version luceneVersion;
    protected int compId;
    private Version minCompatVersion;
    private Version minIndexCompatVersion;

    public static Version readVersion(StreamInput in) throws IOException {
        return Version.fromId(in.readVInt());
    }

    public static Version fromId(int id) {
        Version known = CompatibleESVersion.idToVersion.get(id);
        if (known != null) {
            return known;
        }
        return Version.fromIdSlow(id);
    }

    private static Version fromIdSlow(int id) {
        List<Version> versions = DeclaredVersionsHolder.DECLARED_VERSIONS;
        org.apache.lucene.util.Version luceneVersion = org.apache.lucene.util.Version.fromBits((int)(versions.get((int)0).luceneVersion.major - 1), (int)0, (int)0);
        return new CompatibleESVersion(id, luceneVersion);
    }

    public static Version indexCreated(Settings indexSettings) {
        Version indexVersion = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(indexSettings);
        if (indexVersion == V_EMPTY) {
            String message = String.format(Locale.ROOT, "[%s] is not present in the index settings for index with UUID [%s]", IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), indexSettings.get("index.uuid"));
            throw new IllegalStateException(message);
        }
        return indexVersion;
    }

    public static void writeVersion(Version version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static Version min(Version version1, Version version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static Version max(Version version1, Version version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static Version fromString(String version) {
        if (!Strings.hasLength(version)) {
            return CURRENT;
        }
        Version cached = CompatibleESVersion.stringToVersion.get(version);
        if (cached != null) {
            return cached;
        }
        return Version.fromStringSlow(version);
    }

    private static Version fromStringSlow(String version) {
        String[] parts;
        boolean snapshot = version.endsWith("-SNAPSHOT");
        if (snapshot) {
            version = version.substring(0, version.length() - 9);
        }
        if ((parts = version.split("[.-]")).length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            if (rawMajor >= 5 && snapshot) {
                throw new IllegalArgumentException("illegal version format - snapshots are only supported until version 2.x");
            }
            if (rawMajor >= 7 && parts.length == 4) {
                throw new IllegalArgumentException("illegal version format - qualifiers are only supported until version 6.x");
            }
            int betaOffset = rawMajor < 5 ? 0 : 25;
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            int build = 99;
            if (parts.length == 4) {
                String buildStr = parts[3];
                if (buildStr.startsWith("alpha")) {
                    assert (rawMajor >= 5) : "major must be >= 5 but was " + major;
                    build = Integer.parseInt(buildStr.substring(5));
                    assert (build < 25) : "expected a alpha build but " + build + " >= 25";
                } else if (buildStr.startsWith("Beta") || buildStr.startsWith("beta")) {
                    build = betaOffset + Integer.parseInt(buildStr.substring(4));
                    assert (build < 50) : "expected a beta build but " + build + " >= 50";
                } else if (buildStr.startsWith("RC") || buildStr.startsWith("rc")) {
                    build = Integer.parseInt(buildStr.substring(2)) + 50;
                } else {
                    throw new IllegalArgumentException("unable to parse version " + version);
                }
            }
            return Version.fromId(major + minor + revision + build);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version " + version, e);
        }
    }

    Version(int id, org.apache.lucene.util.Version luceneVersion) {
        this.id = id;
        this.major = (byte)(id / 1000000 % 100);
        this.minor = (byte)(id / 10000 % 100);
        this.revision = (byte)(id / 100 % 100);
        this.build = (byte)(id % 100);
        this.luceneVersion = Objects.requireNonNull(luceneVersion);
        this.compId = id ^ 0x8000000;
    }

    public boolean after(Version version) {
        return version.compId < this.compId;
    }

    public boolean onOrAfter(Version version) {
        return version.compId <= this.compId;
    }

    public boolean before(Version version) {
        return version.compId > this.compId;
    }

    public boolean onOrBefore(Version version) {
        return version.compId >= this.compId;
    }

    @Override
    public int compareTo(Version other) {
        return Integer.compare(this.compId, other.compId);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public Version minimumCompatibilityVersion() {
        return CompatibleESVersion.min_es_version;
    }

    public Version minimumIndexCompatibilityVersion() {
        return CompatibleESVersion.min_index_version;
    }

    public boolean isCompatible(Version version) {
        boolean compatible = this.onOrAfter(version.minimumCompatibilityVersion()) && version.onOrAfter(this.minimumCompatibilityVersion());
        return compatible;
    }

    @SuppressForbidden(reason="System.out.*")
    public static void main(String[] args) {
        String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s/%s, JVM: %s", Build.CURRENT.getQualifiedVersion(), Build.CURRENT.flavor().displayName(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), JvmInfo.jvmInfo().version());
        System.out.println(versionOutput);
        System.out.println(V_1_0_0.onOrAfter(CompatibleESVersion.V_7_10_2));
        System.out.println(CompatibleESVersion.V_7_10_2.onOrAfter(V_1_0_0));
        System.out.println(CompatibleESVersion.V_7_10_2.before(V_1_0_0));
        Version v10 = new Version(1000099, org.apache.lucene.util.Version.LATEST);
        System.out.println("v10: " + v10.id + " " + v10.compId + " " + v10);
        Version v11 = new Version(1010099, org.apache.lucene.util.Version.LATEST);
        System.out.println("v11: " + v11.id + " " + v11.compId + " " + v11);
        System.out.println("compId: " + Version.fromId((int)1000099).compId);
        System.out.println("compId: " + Version.fromId((int)7100299).compId);
        Version v2 = Version.fromId(2000099);
        System.out.println(v2.luceneVersion);
        System.out.println(CompatibleESVersion.idToVersion);
        System.out.println(CompatibleESVersion.stringToVersion);
        System.out.println(DeclaredVersionsHolder.DECLARED_VERSIONS);
        System.out.println(CURRENT);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.isAlpha()) {
            sb.append("-alpha");
            sb.append(this.build);
        } else if (this.isBeta()) {
            if (this.major >= 2) {
                sb.append("-beta");
            } else {
                sb.append(".Beta");
            }
            sb.append(this.major < 5 ? this.build : this.build - 25);
        } else if (this.build < 99) {
            if (this.major >= 2) {
                sb.append("-rc");
            } else {
                sb.append(".RC");
            }
            sb.append(this.build - 50);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isBeta() {
        return this.build >= 25 && this.build < 50;
    }

    public boolean isAlpha() {
        return this.build < 25;
    }

    public boolean isRC() {
        return this.build > 50 && this.build < 99;
    }

    public boolean isRelease() {
        return this.build == 99;
    }

    public static List<Version> getDeclaredVersions(Class<?> versionClass) {
        Field[] fields = versionClass.getFields();
        ArrayList<Version> versions = new ArrayList<Version>(fields.length);
        block9: for (Field field : fields) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) && Modifier.isFinal(mod) && Modifier.isPublic(mod) || field.getType() != Version.class) continue;
            switch (field.getName()) {
                case "CURRENT": 
                case "V_EMPTY": {
                    continue block9;
                }
                default: {
                    assert (field.getName().matches("V(_\\d+)+(_(alpha|beta|rc)\\d+)?")) : field.getName();
                    try {
                        versions.add((Version)field.get(null));
                        continue block9;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        Collections.sort(versions);
        return versions;
    }

    private static class DeclaredVersionsHolder {
        static final List<Version> DECLARED_VERSIONS = Collections.unmodifiableList(Version.getDeclaredVersions(Version.class));

        private DeclaredVersionsHolder() {
        }
    }
}

