/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.easysearch.sink;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.DefaultSaveModeHandler;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportSaveMode;
import org.apache.seatunnel.api.source.SupportSchemaEvolution;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.schema.SchemaChangeType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.easysearch.catalog.EasysearchCatalogFactory;
import org.apache.seatunnel.connectors.seatunnel.easysearch.config.EasysearchSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.easysearch.sink.EasysearchSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.easysearch.state.EasysearchAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.easysearch.state.EasysearchCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.easysearch.state.EasysearchSinkState;

public class EasysearchSink
implements SeaTunnelSink<SeaTunnelRow, EasysearchSinkState, EasysearchCommitInfo, EasysearchAggregatedCommitInfo>,
SupportSchemaEvolution,
SupportSaveMode {
    private final ReadonlyConfig pluginConfig;
    private final CatalogTable catalogTable;

    public EasysearchSink(ReadonlyConfig pluginConfig, CatalogTable catalogTable) {
        this.catalogTable = catalogTable;
        this.pluginConfig = pluginConfig;
    }

    public String getPluginName() {
        return "Easysearch";
    }

    public SinkWriter<SeaTunnelRow, EasysearchCommitInfo, EasysearchSinkState> createWriter(SinkWriter.Context context) {
        return new EasysearchSinkWriter(context, this.catalogTable.getSeaTunnelRowType(), this.pluginConfig);
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return super.getWriteCatalogTable();
    }

    public Optional<SaveModeHandler> getSaveModeHandler() {
        CatalogFactory catalogFactory = (CatalogFactory)FactoryUtil.discoverFactory((ClassLoader)Thread.currentThread().getContextClassLoader(), CatalogFactory.class, (String)this.getPluginName());
        if (catalogFactory == null) {
            catalogFactory = new EasysearchCatalogFactory();
        }
        Catalog catalog = catalogFactory.createCatalog(catalogFactory.factoryIdentifier(), this.pluginConfig);
        SchemaSaveMode schemaSaveMode = (SchemaSaveMode)this.pluginConfig.get(EasysearchSinkOptions.SCHEMA_SAVE_MODE);
        DataSaveMode dataSaveMode = (DataSaveMode)this.pluginConfig.get(EasysearchSinkOptions.DATA_SAVE_MODE);
        String indexName = this.catalogTable.getTableId().getTableName();
        TablePath tablePath = TablePath.of((String)indexName, (String)indexName);
        return Optional.of(new DefaultSaveModeHandler(schemaSaveMode, dataSaveMode, catalog, tablePath, null, null));
    }

    public List<SchemaChangeType> supports() {
        return Arrays.asList(SchemaChangeType.ADD_COLUMN);
    }
}

