/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.ogg;

import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.CommonOptions;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.format.json.JsonSerializationSchema;
import org.apache.seatunnel.format.json.exception.SeaTunnelJsonFormatException;

public class OggJsonSerializationSchema
implements SerializationSchema {
    private static final long serialVersionUID = 1L;
    private static final String OP_INSERT = "INSERT";
    private static final String OP_DELETE = "DELETE";
    public static final String FORMAT = "Ogg";
    private transient SeaTunnelRow reuse;
    private final JsonSerializationSchema jsonSerializer;

    public OggJsonSerializationSchema(SeaTunnelRowType rowType) {
        this.jsonSerializer = new JsonSerializationSchema(OggJsonSerializationSchema.createJsonRowType(rowType));
        this.reuse = new SeaTunnelRow(4);
    }

    public byte[] serialize(SeaTunnelRow row) {
        try {
            String opType = this.rowKind2String(row.getRowKind());
            this.reuse.setField(0, (Object)row);
            this.reuse.setField(1, (Object)opType);
            if (!StringUtils.isEmpty(row.getTableId())) {
                this.reuse.setField(2, (Object)row.getTableId());
            }
            if (row.getOptions() != null && row.getOptions().containsKey(CommonOptions.EVENT_TIME.getName())) {
                this.reuse.setField(3, row.getOptions().get(CommonOptions.EVENT_TIME.getName()));
            }
            return this.jsonSerializer.serialize(this.reuse);
        }
        catch (Throwable t) {
            throw CommonError.jsonOperationError((String)FORMAT, (String)row.toString(), (Throwable)t);
        }
    }

    private String rowKind2String(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: 
            case UPDATE_AFTER: {
                return OP_INSERT;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                return OP_DELETE;
            }
        }
        throw new SeaTunnelJsonFormatException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("Unsupported operation %s for row kind.", rowKind));
    }

    private static SeaTunnelRowType createJsonRowType(SeaTunnelRowType databaseSchema) {
        return new SeaTunnelRowType(new String[]{"data", "type", "table", "op_ts"}, new SeaTunnelDataType[]{databaseSchema, BasicType.STRING_TYPE, BasicType.STRING_TYPE, BasicType.LONG_TYPE});
    }
}

