/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.jdbc.DatabendColumnInfo;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;

public class DatabendResultSetMetaData
implements ResultSetMetaData {
    private final List<DatabendColumnInfo> databendColumnInfo;

    DatabendResultSetMetaData(List<DatabendColumnInfo> databendColumnInfo) {
        this.databendColumnInfo = databendColumnInfo;
    }

    static String getTypeClassName(int type) {
        switch (type) {
            case 2: 
            case 3: {
                return BigDecimal.class.getName();
            }
            case -7: 
            case 16: {
                return Boolean.class.getName();
            }
            case -6: {
                return Byte.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 7: {
                return Float.class.getName();
            }
            case 6: 
            case 8: {
                return Double.class.getName();
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
            case 91: {
                return Date.class.getName();
            }
            case 92: {
                return Time.class.getName();
            }
            case 93: {
                return Timestamp.class.getName();
            }
            case 2004: {
                return Blob.class.getName();
            }
            case 2005: {
                return Clob.class.getName();
            }
            case 2003: {
                return Array.class.getName();
            }
            case 0: {
                return "unknown";
            }
        }
        return String.class.getName();
    }

    @Override
    public int getColumnCount() throws SQLException {
        if (this.databendColumnInfo == null) {
            return 0;
        }
        return this.databendColumnInfo.size();
    }

    @Override
    public boolean isAutoIncrement(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int i) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int i) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int i) throws SQLException {
        DatabendColumnInfo.Nullable nullable = this.column(i).getNullable();
        switch (nullable) {
            case NO_NULLS: {
                return 0;
            }
            case NULLABLE: {
                return 1;
            }
            case UNKNOWN: {
                return 2;
            }
        }
        throw new SQLException("Unhandled nullable type: " + (Object)((Object)nullable));
    }

    @Override
    public boolean isSigned(int i) throws SQLException {
        return this.column(i).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int i) throws SQLException {
        return this.column(i).getColumnDisplaySize();
    }

    @Override
    public String getColumnLabel(int i) throws SQLException {
        return this.column(i).getColumnLabel();
    }

    @Override
    public String getColumnName(int i) throws SQLException {
        return this.column(i).getColumnName();
    }

    @Override
    public String getSchemaName(int i) throws SQLException {
        return this.column(i).getSchemaName();
    }

    @Override
    public int getPrecision(int i) throws SQLException {
        return this.column(i).getPrecision();
    }

    @Override
    public int getScale(int i) throws SQLException {
        return this.column(i).getScale();
    }

    @Override
    public String getTableName(int i) throws SQLException {
        return this.column(i).getTableName();
    }

    @Override
    public String getCatalogName(int i) throws SQLException {
        return this.column(i).getCatalogName();
    }

    @Override
    public int getColumnType(int i) throws SQLException {
        return this.column(i).getColumnType();
    }

    @Override
    public String getColumnTypeName(int i) throws SQLException {
        return this.column(i).getColumnTypeName();
    }

    @Override
    public boolean isReadOnly(int i) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int i) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int i) throws SQLException {
        return DatabendResultSetMetaData.getTypeClassName(this.column(i).getColumnType());
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return false;
    }

    private DatabendColumnInfo column(int column) throws SQLException {
        if (column <= 0 || column > this.databendColumnInfo.size()) {
            throw new SQLException("Invalid column index: " + column);
        }
        return this.databendColumnInfo.get(column - 1);
    }
}

