/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.BooleanHandler;
import com.databend.client.data.ColumnTypeHandler;
import com.databend.client.data.DatabendRawType;
import com.databend.client.data.DecimalHandler;
import com.databend.client.data.Float32Handler;
import com.databend.client.data.Float64Handler;
import com.databend.client.data.GeometryHandler;
import com.databend.client.data.Int16Handler;
import com.databend.client.data.Int32Handler;
import com.databend.client.data.Int64Handler;
import com.databend.client.data.Int8Handler;
import com.databend.client.data.StringHandler;
import com.databend.client.data.UInt16Handler;
import com.databend.client.data.UInt32Handler;
import com.databend.client.data.UInt64Handler;
import com.databend.client.data.UInt8Handler;
import java.util.Locale;

public class ColumnTypeHandlerFactory {
    public static ColumnTypeHandler getTypeHandler(DatabendRawType type) {
        if (type == null) {
            return null;
        }
        switch (type.getDataType().getDisplayName().toLowerCase(Locale.US)) {
            case "int8": {
                return new Int8Handler(type.isNullable());
            }
            case "int16": {
                return new Int16Handler(type.isNullable());
            }
            case "int32": {
                return new Int32Handler(type.isNullable());
            }
            case "int64": {
                return new Int64Handler(type.isNullable());
            }
            case "uint8": {
                return new UInt8Handler(type.isNullable());
            }
            case "uint16": {
                return new UInt16Handler(type.isNullable());
            }
            case "uint32": {
                return new UInt32Handler(type.isNullable());
            }
            case "uint64": {
                return new UInt64Handler(type.isNullable());
            }
            case "float32": {
                return new Float32Handler(type.isNullable());
            }
            case "float64": {
                return new Float64Handler(type.isNullable());
            }
            case "boolean": {
                return new BooleanHandler(type.isNullable());
            }
            case "decimal": {
                return new DecimalHandler(type.isNullable());
            }
            case "geometry": {
                return new GeometryHandler(type.isNullable());
            }
        }
        return new StringHandler(type.isNullable());
    }
}

