/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.databend.client.DiscoveryResponseCodec;
import com.databend.jdbc.com.fasterxml.jackson.core.JsonParser;
import com.databend.jdbc.com.fasterxml.jackson.core.JsonProcessingException;
import com.databend.jdbc.com.fasterxml.jackson.databind.DeserializationFeature;
import com.databend.jdbc.com.fasterxml.jackson.databind.JavaType;
import com.databend.jdbc.com.fasterxml.jackson.databind.MapperFeature;
import com.databend.jdbc.com.fasterxml.jackson.databind.ObjectMapper;
import com.databend.jdbc.com.fasterxml.jackson.databind.module.SimpleModule;
import com.databend.jdbc.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.shaded.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Supplier;

public class JsonCodec<T> {
    static final Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = () -> new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(MapperFeature.AUTO_DETECT_CREATORS).disable(MapperFeature.AUTO_DETECT_FIELDS).disable(MapperFeature.AUTO_DETECT_SETTERS).disable(MapperFeature.AUTO_DETECT_GETTERS).disable(MapperFeature.AUTO_DETECT_IS_GETTERS).disable(MapperFeature.USE_GETTERS_AS_SETTERS).disable(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS).disable(MapperFeature.INFER_PROPERTY_MUTATORS).disable(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS).registerModule(new Jdk8Module()).registerModule(new SimpleModule().addDeserializer(DiscoveryResponseCodec.DiscoveryResponse.class, new DiscoveryResponseCodec.DiscoveryResponseDeserializer()));
    private final ObjectMapper mapper;
    private final Type type;
    private final JavaType javaType;

    private JsonCodec(ObjectMapper mapper, Type type) {
        this.mapper = Objects.requireNonNull(mapper, "mapper is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.javaType = mapper.getTypeFactory().constructType(type);
    }

    public static <T> JsonCodec<T> jsonCodec(Class<T> type) {
        return new JsonCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type);
    }

    public Type getType() {
        return this.type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T fromJson(String json) throws JsonProcessingException {
        try (JsonParser parser = this.mapper.createParser(json);){
            Object value = this.mapper.readerFor(this.javaType).readValue(parser);
            Preconditions.checkArgument(parser.nextToken() == null, "Found characters after the expected end of input");
            Object t = value;
            return t;
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public T fromJson(InputStream inputStream2) throws IOException, JsonProcessingException {
        try (JsonParser parser = this.mapper.createParser(inputStream2);){
            Object value = this.mapper.readerFor(this.javaType).readValue(parser);
            Preconditions.checkArgument(parser.nextToken() == null, "Found characters after the expected end of input");
            Object t = value;
            return t;
        }
    }
}

