/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.databend.client.DatabendSession;
import com.databend.client.PaginationOptions;
import com.databend.client.StageAttachment;
import java.util.HashMap;
import java.util.Map;

public class ClientSettings {
    public static final Integer DEFAULT_QUERY_TIMEOUT = 300;
    public static final Integer DEFAULT_CONNECTION_TIMEOUT = 0;
    public static final Integer DEFAULT_SOCKET_TIMEOUT = 0;
    public static final int DEFAULT_RETRY_ATTEMPTS = 5;
    public static final String X_Databend_Query_ID = "X-DATABEND-QUERY-ID";
    public static final String X_DATABEND_VERSION = "X-DATABEND-VERSION";
    public static final String X_DATABEND_ROUTE_HINT = "X-DATABEND-ROUTE-HINT";
    public static final String X_DATABEND_STAGE_NAME = "X-DATABEND-STAGE-NAME";
    public static final String X_DATABEND_RELATIVE_PATH = "X-DATABEND-RELATIVE-PATH";
    public static final String X_DATABEND_STICKY_NODE = "X-DATABEND-STICKY-NODE";
    public static final String DatabendWarehouseHeader = "X-DATABEND-WAREHOUSE";
    public static final String DatabendTenantHeader = "X-DATABEND-TENANT";
    private final String host;
    private final DatabendSession session;
    private final Integer queryTimeoutSecs;
    private final Integer connectionTimeout;
    private final Integer socketTimeout;
    private final PaginationOptions paginationOptions;
    private final StageAttachment stageAttachment;
    private Map<String, String> additionalHeaders;
    private final int retryAttempts;

    public ClientSettings(String host) {
        this(host, DatabendSession.createDefault(), DEFAULT_QUERY_TIMEOUT, DEFAULT_CONNECTION_TIMEOUT, DEFAULT_SOCKET_TIMEOUT, PaginationOptions.defaultPaginationOptions(), new HashMap<String, String>(), null, 5);
    }

    public ClientSettings(String host, String database) {
        DatabendSession session = new DatabendSession.Builder().setDatabase(database).build();
        this.host = host;
        this.session = session;
        this.queryTimeoutSecs = DEFAULT_QUERY_TIMEOUT;
        this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
        this.socketTimeout = DEFAULT_SOCKET_TIMEOUT;
        this.paginationOptions = PaginationOptions.defaultPaginationOptions();
        this.additionalHeaders = new HashMap<String, String>();
        this.stageAttachment = null;
        this.retryAttempts = 5;
    }

    public ClientSettings(String host, DatabendSession session, Integer queryTimeoutSecs, Integer connectionTimeout, Integer socketTimeout, PaginationOptions paginationOptions, Map<String, String> additionalHeaders, StageAttachment stageAttachment, int retryAttempts) {
        this.host = host;
        this.session = session;
        this.queryTimeoutSecs = queryTimeoutSecs;
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
        this.paginationOptions = paginationOptions;
        this.additionalHeaders = additionalHeaders;
        this.stageAttachment = stageAttachment;
        this.retryAttempts = retryAttempts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DatabendSession getSession() {
        return this.session;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getQueryTimeoutSecs() {
        return this.queryTimeoutSecs;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public PaginationOptions getPaginationOptions() {
        return this.paginationOptions;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public StageAttachment getStageAttachment() {
        return this.stageAttachment;
    }

    public int getRetryAttempts() {
        if (this.retryAttempts <= 0) {
            return 5;
        }
        return this.retryAttempts;
    }

    public static class Builder {
        private DatabendSession session;
        private String host;
        private Integer queryTimeoutSecs;
        private Integer connectionTimeout;
        private Integer socketTimeout;
        private PaginationOptions paginationOptions;
        private StageAttachment stageAttachment;
        private Map<String, String> additionalHeaders;
        private int retryAttempts;

        public Builder setSession(DatabendSession session) {
            this.session = session;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setConnectionTimeout(Integer timeout2) {
            this.connectionTimeout = timeout2;
            return this;
        }

        public Builder setSocketTimeout(Integer timeout2) {
            this.socketTimeout = timeout2;
            return this;
        }

        public Builder setQueryTimeoutSecs(Integer queryTimeoutSecs) {
            if (queryTimeoutSecs <= 0) {
                queryTimeoutSecs = DEFAULT_QUERY_TIMEOUT;
            }
            this.queryTimeoutSecs = queryTimeoutSecs;
            return this;
        }

        public Builder setPaginationOptions(PaginationOptions paginationOptions) {
            this.paginationOptions = paginationOptions;
            return this;
        }

        public Builder setAdditionalHeaders(Map<String, String> additionalHeaders) {
            this.additionalHeaders = additionalHeaders;
            return this;
        }

        public Builder setRetryAttempts(int retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        public Builder setStageAttachment(StageAttachment stageAttachment) {
            this.stageAttachment = stageAttachment;
            return this;
        }

        public ClientSettings build() {
            return new ClientSettings(this.host, this.session, this.queryTimeoutSecs, this.connectionTimeout, this.socketTimeout, this.paginationOptions, this.additionalHeaders, this.stageAttachment, this.retryAttempts);
        }
    }
}

