/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor;

import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CopyManagerProxy {
    private static final Logger LOG = LoggerFactory.getLogger(CopyManagerProxy.class);
    Object connection;
    Object copyManager;
    Class<?> connectionClazz;
    Class<?> copyManagerClazz;
    Method getCopyAPIMethod;
    Method copyInMethod;

    CopyManagerProxy(Connection connection) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, SQLException {
        LOG.info("Proxy connection class: {}", (Object)connection.getClass().getName());
        this.connection = connection.unwrap(Connection.class);
        LOG.info("Proxy unwrap connection class: {}", (Object)this.connection.getClass().getName());
        if (Proxy.isProxyClass(this.connection.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(this.connection);
            this.connection = CopyManagerProxy.getConnectionFromInvocationHandler(handler);
            if (null == this.connection) {
                throw new InvocationTargetException(new NullPointerException("Proxy Connection is null."));
            }
            LOG.info("Proxy connection class: {}", (Object)this.connection.getClass().getName());
            this.connectionClazz = this.connection.getClass();
        } else {
            this.connectionClazz = this.connection.getClass();
        }
        this.getCopyAPIMethod = this.connectionClazz.getMethod("getCopyAPI", new Class[0]);
        this.copyManager = this.getCopyAPIMethod.invoke(this.connection, new Object[0]);
        this.copyManagerClazz = this.copyManager.getClass();
        this.copyInMethod = this.copyManagerClazz.getMethod("copyIn", String.class, Reader.class);
    }

    long doCopy(String sql, Reader reader) throws InvocationTargetException, IllegalAccessException {
        return (Long)this.copyInMethod.invoke(this.copyManager, sql, reader);
    }

    private static Object getConnectionFromInvocationHandler(InvocationHandler handler) throws IllegalAccessException {
        Class<?> handlerClass = handler.getClass();
        LOG.info("InvocationHandler class: {}", (Object)handlerClass.getName());
        for (Field declaredField : handlerClass.getDeclaredFields()) {
            Object handlerObject;
            boolean tempAccessible = declaredField.isAccessible();
            if (!tempAccessible) {
                declaredField.setAccessible(true);
            }
            if ((handlerObject = declaredField.get(handler)) instanceof Connection) {
                if (!tempAccessible) {
                    declaredField.setAccessible(tempAccessible);
                }
                return handlerObject;
            }
            if (tempAccessible) continue;
            declaredField.setAccessible(tempAccessible);
        }
        return null;
    }
}

