/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.iris;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.iris.IrisTypeConverter;

public class IrisCreateTableSqlBuilder {
    private List<Column> columns;
    private PrimaryKey primaryKey;
    List<ConstraintKey> constraintKeys;
    private String sourceCatalogName;
    private String fieldIde;
    private String comment;
    private boolean createIndex;

    public IrisCreateTableSqlBuilder(CatalogTable catalogTable, boolean createIndex) {
        this.columns = catalogTable.getTableSchema().getColumns();
        this.primaryKey = catalogTable.getTableSchema().getPrimaryKey();
        this.constraintKeys = catalogTable.getTableSchema().getConstraintKeys();
        this.sourceCatalogName = catalogTable.getCatalogName();
        this.fieldIde = (String)catalogTable.getOptions().get("fieldIde");
        this.comment = catalogTable.getComment();
        this.createIndex = createIndex;
    }

    public String build(TablePath tablePath) {
        String indexKeySql = "";
        StringBuilder createTableSql = new StringBuilder();
        createTableSql.append("CREATE TABLE ").append(tablePath.getSchemaAndTableName("\"")).append(" (\n");
        List columnSqls = this.columns.stream().map(column -> CatalogUtils.getFieldIde(this.buildColumnSql((Column)column), this.fieldIde)).collect(Collectors.toList());
        if (this.createIndex && this.primaryKey != null && this.primaryKey.getColumnNames() != null && this.primaryKey.getColumnNames().size() > 0) {
            columnSqls.add(this.buildPrimaryKeySql(this.primaryKey));
        }
        if (this.createIndex && CollectionUtils.isNotEmpty(this.constraintKeys)) {
            for (ConstraintKey constraintKey : this.constraintKeys) {
                if (StringUtils.isBlank((CharSequence)constraintKey.getConstraintName()) || this.primaryKey != null && StringUtils.equals((CharSequence)this.primaryKey.getPrimaryKey(), (CharSequence)constraintKey.getConstraintName())) continue;
                switch (constraintKey.getConstraintType()) {
                    case UNIQUE_KEY: {
                        String uniqueKeySql = this.buildUniqueKeySql(constraintKey);
                        columnSqls.add(uniqueKeySql);
                        break;
                    }
                    case INDEX_KEY: {
                        indexKeySql = this.buildIndexKeySql(tablePath, constraintKey);
                        break;
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.comment)) {
            createTableSql.append(" %Description '" + this.comment + "',\n");
        }
        createTableSql.append(String.join((CharSequence)",\n", columnSqls));
        createTableSql.append("\n);");
        createTableSql.append("\n" + indexKeySql);
        return createTableSql.toString();
    }

    private String buildColumnSql(Column column) {
        StringBuilder columnSql = new StringBuilder();
        columnSql.append("\"").append(column.getName()).append("\" ");
        String columnType = column.getSinkType() != null ? column.getSinkType() : (StringUtils.equals((CharSequence)this.sourceCatalogName, (CharSequence)"IRIS") && StringUtils.isNotEmpty((CharSequence)column.getSourceType()) ? column.getSourceType() : IrisTypeConverter.INSTANCE.reconvert(column).getColumnType());
        columnSql.append(columnType);
        if (!column.isNullable()) {
            columnSql.append(" NOT NULL");
        }
        if (StringUtils.isNotBlank((CharSequence)column.getComment())) {
            columnSql.append(" %Description '" + column.getComment() + "'");
        }
        return columnSql.toString();
    }

    private String buildPrimaryKeySql(PrimaryKey primaryKey) {
        String columnNamesString = primaryKey.getColumnNames().stream().map(columnName -> "\"" + columnName + "\"").collect(Collectors.joining(", "));
        return CatalogUtils.getFieldIde(" PRIMARY KEY (" + columnNamesString + ")", this.fieldIde);
    }

    private String buildUniqueKeySql(ConstraintKey constraintKey) {
        String indexColumns = constraintKey.getColumnNames().stream().map(constraintKeyColumn -> String.format("\"%s\"", CatalogUtils.getFieldIde(constraintKeyColumn.getColumnName(), this.fieldIde))).collect(Collectors.joining(", "));
        return "UNIQUE (" + indexColumns + ")";
    }

    private String buildIndexKeySql(TablePath tablePath, ConstraintKey constraintKey) {
        String constraintName = tablePath.getTableName() + "_" + constraintKey.getConstraintName();
        String indexColumns = constraintKey.getColumnNames().stream().map(constraintKeyColumn -> String.format("\"%s\"", CatalogUtils.getFieldIde(constraintKeyColumn.getColumnName(), this.fieldIde))).collect(Collectors.joining(", "));
        return "CREATE INDEX " + constraintName + " ON " + tablePath.getSchemaAndTableName("\"") + "(" + indexColumns + ");";
    }
}

