/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.log;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.tikv.common.log.SlowLogSpan;
import org.tikv.shade.com.google.gson.JsonElement;
import org.tikv.shade.com.google.gson.JsonObject;

public class SlowLogSpanImpl
implements SlowLogSpan {
    private final String name;
    private final long requestStartInstantNS;
    private final long requestStartUnixNS;
    private final Map<String, String> properties;
    private long startInstantNS;
    private long endInstantNS;

    public SlowLogSpanImpl(String name, long requestStartMS, long requestStartInstantNS) {
        this.name = name;
        this.requestStartUnixNS = requestStartMS * 1000000L;
        this.requestStartInstantNS = requestStartInstantNS;
        this.properties = new HashMap<String, String>();
        this.startInstantNS = 0L;
        this.endInstantNS = 0L;
    }

    @Override
    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public void start() {
        this.startInstantNS = System.nanoTime();
    }

    @Override
    public void end() {
        this.endInstantNS = System.nanoTime();
    }

    @Override
    public JsonElement toJsonElement() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("event", this.name);
        jsonObject.addProperty("begin", dateFormat.format(this.getStartUnixNS() / 1000000L));
        jsonObject.addProperty("duration_ms", this.getDurationNS() / 1000000L);
        if (!this.properties.isEmpty()) {
            JsonObject propertiesObject = new JsonObject();
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                propertiesObject.addProperty(entry.getKey(), entry.getValue());
            }
            jsonObject.add("properties", propertiesObject);
        }
        return jsonObject;
    }

    private long getStartUnixNS() {
        return this.requestStartUnixNS + (this.startInstantNS - this.requestStartInstantNS);
    }

    private long getDurationNS() {
        if (this.startInstantNS == 0L || this.endInstantNS == 0L) {
            return -1L;
        }
        return this.endInstantNS - this.startInstantNS;
    }
}

