/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor.CopyManagerProxy;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor.JdbcBatchStatementExecutor;

public class CopyManagerBatchStatementExecutor
implements JdbcBatchStatementExecutor<SeaTunnelRow> {
    private final String copySql;
    private final TableSchema tableSchema;
    CopyManagerProxy copyManagerProxy;
    CSVFormat csvFormat = CSVFormat.POSTGRESQL_CSV;
    CSVPrinter csvPrinter;

    public CopyManagerBatchStatementExecutor(String copySql, TableSchema tableSchema) {
        this.copySql = copySql;
        this.tableSchema = tableSchema;
    }

    public static void copyManagerProxyChecked(JdbcConnectionProvider connectionProvider) {
        try (Connection connection = connectionProvider.getConnection();){
            new CopyManagerProxy(connection);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new JdbcConnectorException(JdbcConnectorErrorCode.NO_SUPPORT_OPERATION_FAILED, "unable to open CopyManager Operation in this JDBC writer. Please configure option use_copy_statement = false.", e);
        }
        catch (SQLException e) {
            throw new JdbcConnectorException(JdbcConnectorErrorCode.CREATE_DRIVER_FAILED, "unable to open JDBC writer", e);
        }
    }

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        try {
            this.copyManagerProxy = new CopyManagerProxy(connection);
            this.csvPrinter = new CSVPrinter((Appendable)new StringBuilder(), this.csvFormat);
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new JdbcConnectorException(JdbcConnectorErrorCode.NO_SUPPORT_OPERATION_FAILED, "unable to open CopyManager Operation in this JDBC writer. Please configure option use_copy_statement = false.", e);
        }
        catch (SQLException e) {
            throw new JdbcConnectorException(JdbcConnectorErrorCode.CREATE_DRIVER_FAILED, "unable to open JDBC writer", e);
        }
    }

    @Override
    public void addToBatch(SeaTunnelRow record) throws SQLException {
        try {
            this.csvPrinter.printRecord(this.toExtract(record));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Object> toExtract(SeaTunnelRow record) {
        SeaTunnelRowType rowType = this.tableSchema.toPhysicalRowDataType();
        ArrayList<Object> csvRecord = new ArrayList<Object>();
        block16: for (int fieldIndex = 0; fieldIndex < rowType.getTotalFields(); ++fieldIndex) {
            SeaTunnelDataType seaTunnelDataType = rowType.getFieldType(fieldIndex);
            Object fieldValue = record.getField(fieldIndex);
            if (fieldValue == null) {
                csvRecord.add(null);
                continue;
            }
            switch (seaTunnelDataType.getSqlType()) {
                case STRING: {
                    csvRecord.add((String)record.getField(fieldIndex));
                    continue block16;
                }
                case BOOLEAN: {
                    csvRecord.add((Boolean)record.getField(fieldIndex));
                    continue block16;
                }
                case TINYINT: {
                    csvRecord.add((Byte)record.getField(fieldIndex));
                    continue block16;
                }
                case SMALLINT: {
                    csvRecord.add((Short)record.getField(fieldIndex));
                    continue block16;
                }
                case INT: {
                    csvRecord.add((Integer)record.getField(fieldIndex));
                    continue block16;
                }
                case BIGINT: {
                    csvRecord.add((Long)record.getField(fieldIndex));
                    continue block16;
                }
                case FLOAT: {
                    csvRecord.add((Float)record.getField(fieldIndex));
                    continue block16;
                }
                case DOUBLE: {
                    csvRecord.add((Double)record.getField(fieldIndex));
                    continue block16;
                }
                case DECIMAL: {
                    csvRecord.add((BigDecimal)record.getField(fieldIndex));
                    continue block16;
                }
                case DATE: {
                    LocalDate localDate = (LocalDate)record.getField(fieldIndex);
                    csvRecord.add(Date.valueOf(localDate));
                    continue block16;
                }
                case TIME: {
                    LocalTime localTime = (LocalTime)record.getField(fieldIndex);
                    csvRecord.add(Time.valueOf(localTime));
                    continue block16;
                }
                case TIMESTAMP: {
                    LocalDateTime localDateTime = (LocalDateTime)record.getField(fieldIndex);
                    csvRecord.add(Timestamp.valueOf(localDateTime));
                    continue block16;
                }
                case BYTES: {
                    csvRecord.add(Base64.encodeBase64String((byte[])record.getField(fieldIndex)));
                    continue block16;
                }
                case NULL: {
                    csvRecord.add(null);
                    continue block16;
                }
                default: {
                    throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType);
                }
            }
        }
        return csvRecord;
    }

    @Override
    public void executeBatch() throws SQLException {
        try {
            this.csvPrinter.flush();
            this.copyManagerProxy.doCopy(this.copySql, new StringReader(this.csvPrinter.getOut().toString()));
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.SQL_OPERATION_FAILED, "Sql command: " + this.copySql);
        }
        finally {
            try {
                this.csvPrinter.close();
                this.csvPrinter = new CSVPrinter((Appendable)new StringBuilder(), this.csvFormat);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void closeStatements() throws SQLException {
        this.copyManagerProxy = null;
        try {
            this.csvPrinter.close();
            this.csvPrinter = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

