/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.replica;

import java.util.Iterator;
import java.util.List;
import org.tikv.common.region.TiStore;
import org.tikv.common.replica.Store;
import org.tikv.kvproto.Metapb;
import org.tikv.shade.com.google.common.base.MoreObjects;

public class Region {
    private final Metapb.Region region;
    private final Store[] stores;
    private Store leaderStore;

    public Region(Metapb.Region region, Metapb.Peer leader, List<Metapb.Peer> peers, List<TiStore> stores) {
        this.region = region;
        this.stores = new Store[stores.size()];
        Iterator<Metapb.Peer> peer = peers.iterator();
        Iterator<TiStore> store = stores.iterator();
        for (int idx = 0; idx < peers.size(); ++idx) {
            Metapb.Peer currentPeer = peer.next();
            boolean isLeader = currentPeer.equals(leader);
            this.stores[idx] = new Store(currentPeer, store.next().getStore(), isLeader);
            if (!isLeader) continue;
            this.leaderStore = this.stores[idx];
        }
    }

    public Store[] getStores() {
        return this.stores;
    }

    public Store getLeader() {
        return this.leaderStore;
    }

    public long getId() {
        return this.region.getId();
    }

    public byte[] getStartKey() {
        return this.region.getStartKey().toByteArray();
    }

    public byte[] getEndKey() {
        return this.region.getEndKey().toByteArray();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("region", this.region).add("stores", this.stores).toString();
    }
}

