/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.columnar;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.joda.time.LocalDate;
import org.tikv.common.columnar.TiColumnVector;
import org.tikv.common.columnar.datatypes.CHType;
import org.tikv.common.types.AbstractDateTimeType;
import org.tikv.common.types.BytesType;
import org.tikv.common.types.DateType;
import org.tikv.common.util.MemoryUtil;

public class TiBlockColumnVector
extends TiColumnVector {
    private final ByteBuffer offsets;
    private final ByteBuffer nullMap;
    private final ByteBuffer data;
    private final int fixedLength;

    public TiBlockColumnVector(CHType type, ByteBuffer data, int numOfRows, int fixedLength) {
        super(type.toDataType(), numOfRows);
        this.data = Objects.requireNonNull(data);
        this.nullMap = null;
        this.offsets = null;
        this.fixedLength = fixedLength;
    }

    public TiBlockColumnVector(CHType type) {
        super(type.toDataType(), 0);
        this.data = MemoryUtil.EMPTY_BYTE_BUFFER;
        this.nullMap = null;
        this.offsets = null;
        this.fixedLength = -1;
    }

    public TiBlockColumnVector(CHType type, ByteBuffer nullMap, ByteBuffer data, int numOfRows, int fixedLength) {
        super(type.toDataType(), numOfRows);
        this.nullMap = Objects.requireNonNull(nullMap);
        this.data = Objects.requireNonNull(data);
        this.offsets = null;
        this.fixedLength = fixedLength;
    }

    public TiBlockColumnVector(CHType type, ByteBuffer nullMap, ByteBuffer offsets, ByteBuffer data, int numOfRows) {
        super(type.toDataType(), numOfRows);
        this.offsets = Objects.requireNonNull(offsets);
        this.nullMap = nullMap;
        this.data = Objects.requireNonNull(data);
        this.fixedLength = -1;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNull() {
        if (this.nullMap != null) {
            byte[] array;
            for (byte b : array = this.nullMap.array()) {
                if (b == 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int numNulls() {
        int n = 0;
        if (this.nullMap != null) {
            byte[] array;
            for (byte b : array = this.nullMap.array()) {
                if (b == 0) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public boolean isNullAt(int rowId) {
        return this.nullMap != null && this.nullMap.get(rowId) != 0;
    }

    @Override
    public boolean getBoolean(int rowId) {
        return false;
    }

    @Override
    public byte getByte(int rowId) {
        return this.data.get(rowId);
    }

    @Override
    public short getShort(int rowId) {
        return this.data.getShort(rowId << 1);
    }

    @Override
    public int getInt(int rowId) {
        if (this.type instanceof DateType) {
            return (int)this.getTime(rowId);
        }
        return this.data.getInt(rowId << 2);
    }

    private long getDateTime(int rowId) {
        long v = this.data.getLong(rowId << 3);
        long ymdhms = v >>> 24;
        long ymd = ymdhms >>> 17;
        int day = (int)(ymd & 0x1FL);
        long ym = ymd >>> 5;
        int month = (int)(ym % 13L);
        int year = (int)(ym / 13L);
        int hms = (int)(ymdhms & 0x1FFFFL);
        int second = hms & 0x3F;
        int minute = hms >>> 6 & 0x3F;
        int hour = hms >>> 12;
        int microsec = (int)(v % 0x1000000L);
        ZonedDateTime zdt = ZonedDateTime.of(year, month, day, hour, minute, second, microsec * 1000, ZoneId.systemDefault());
        Instant instant = zdt.toInstant();
        return instant.getEpochSecond() * 1000000L + (long)(instant.getNano() / 1000);
    }

    private long getTime(int rowId) {
        long v = this.data.getLong(rowId << 3);
        long ymd = v >>> 41;
        long ym = ymd >>> 5;
        int year = (int)(ym / 13L);
        int month = (int)(ym % 13L);
        int day = (int)(ymd & 0x1FL);
        LocalDate date = new LocalDate(year, month, day);
        return ((DateType)this.type).getDays(date);
    }

    @Override
    public long getLong(int rowId) {
        if (this.type instanceof AbstractDateTimeType) {
            return this.getDateTime(rowId);
        }
        if (this.fixedLength == 1) {
            return this.getByte(rowId);
        }
        if (this.fixedLength == 2) {
            return this.getShort(rowId);
        }
        if (this.fixedLength == 4) {
            return this.getInt(rowId);
        }
        if (this.fixedLength == 8) {
            return this.data.getLong(rowId << 3);
        }
        throw new UnsupportedOperationException(String.format("getting long with fixed length %d", this.fixedLength));
    }

    @Override
    public float getFloat(int rowId) {
        return this.data.getFloat(rowId * this.fixedLength);
    }

    @Override
    public double getDouble(int rowId) {
        return this.data.getDouble(rowId * this.fixedLength);
    }

    @Override
    public BigDecimal getDecimal(int rowId, int precision, int scale) {
        if (this.fixedLength == 4) {
            return MemoryUtil.getDecimal32(this.data, rowId << 2, scale);
        }
        if (this.fixedLength == 8) {
            return MemoryUtil.getDecimal64(this.data, rowId << 3, scale);
        }
        if (this.fixedLength == 16) {
            return MemoryUtil.getDecimal128(this.data, rowId << 4, scale);
        }
        return MemoryUtil.getDecimal256(this.data, rowId * this.fixedLength, scale);
    }

    private long offsetAt(int i) {
        return i == 0 ? 0L : this.offsets.getLong(i - 1 << 3);
    }

    public int sizeAt(int i) {
        return (int)(i == 0 ? this.offsets.getLong(0) : this.offsets.getLong(i << 3) - this.offsets.getLong(i - 1 << 3));
    }

    @Override
    public String getUTF8String(int rowId) {
        if (this.fixedLength != -1) {
            byte[] chars = new byte[this.fixedLength];
            this.data.get(chars, rowId * this.fixedLength, this.fixedLength);
            return new String(chars);
        }
        int offset = (int)this.offsetAt(rowId);
        int numBytes = this.sizeAt(rowId) - 1;
        byte[] chars = new byte[numBytes];
        this.data.get(chars, offset, numBytes);
        return new String(chars, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] getBinary(int rowId) {
        if (this.type.equals(BytesType.BLOB) || this.type.equals(BytesType.TINY_BLOB)) {
            int offset = (int)this.offsetAt(rowId);
            int numBytes = this.sizeAt(rowId) - 1;
            byte[] ret = new byte[numBytes];
            this.data.get(ret, offset, numBytes);
            return ret;
        }
        throw new UnsupportedOperationException("get Binary for TiBlockColumnVector is not supported");
    }

    @Override
    protected TiColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException("getChild is not supported for TiBlockColumnVector");
    }
}

