/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Method;
import org.joda.convert.AbstractTypeStringConverter;
import org.joda.convert.TypedStringConverter;

final class OptionalIntStringConverter
extends AbstractTypeStringConverter
implements TypedStringConverter<Object> {
    private static final Class<?> TYPE;
    private static final Object EMPTY;
    private static final Method METHOD_OF;
    private static final Method METHOD_IS_PRESENT;
    private static final Method METHOD_GET;

    OptionalIntStringConverter() {
    }

    @Override
    public String convertToString(Object object) {
        try {
            Object isPresent = METHOD_IS_PRESENT.invoke(object, new Object[0]);
            return Boolean.TRUE.equals(isPresent) ? String.valueOf(METHOD_GET.invoke(object, new Object[0])) : "";
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public Object convertFromString(Class<? extends Object> cls, String str) {
        if ("".equals(str)) {
            return EMPTY;
        }
        int value = Integer.parseInt(str);
        try {
            return METHOD_OF.invoke(null, value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public Class<?> getEffectiveType() {
        return TYPE;
    }

    static {
        try {
            TYPE = Class.forName("java.util.OptionalInt");
            EMPTY = TYPE.getDeclaredMethod("empty", new Class[0]).invoke(null, new Object[0]);
            METHOD_OF = TYPE.getDeclaredMethod("of", Integer.TYPE);
            METHOD_IS_PRESENT = TYPE.getDeclaredMethod("isPresent", new Class[0]);
            METHOD_GET = TYPE.getDeclaredMethod("getAsInt", new Class[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

