/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlserver;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class SqlServerTypeConverter
implements TypeConverter<BasicTypeDefine> {
    private static final Logger log = LoggerFactory.getLogger(SqlServerTypeConverter.class);
    public static final String SQLSERVER_BIT = "BIT";
    public static final String SQLSERVER_TINYINT = "TINYINT";
    public static final String SQLSERVER_TINYINT_IDENTITY = "TINYINT IDENTITY";
    public static final String SQLSERVER_SMALLINT = "SMALLINT";
    public static final String SQLSERVER_SMALLINT_IDENTITY = "SMALLINT IDENTITY";
    public static final String SQLSERVER_INTEGER = "INTEGER";
    public static final String SQLSERVER_INTEGER_IDENTITY = "INTEGER IDENTITY";
    public static final String SQLSERVER_INT = "INT";
    private static final String SQLSERVER_INT_IDENTITY = "INT IDENTITY";
    public static final String SQLSERVER_BIGINT = "BIGINT";
    public static final String SQLSERVER_BIGINT_IDENTITY = "BIGINT IDENTITY";
    public static final String SQLSERVER_DECIMAL = "DECIMAL";
    public static final String SQLSERVER_FLOAT = "FLOAT";
    public static final String SQLSERVER_REAL = "REAL";
    public static final String SQLSERVER_NUMERIC = "NUMERIC";
    public static final String SQLSERVER_MONEY = "MONEY";
    public static final String SQLSERVER_SMALLMONEY = "SMALLMONEY";
    public static final String SQLSERVER_CHAR = "CHAR";
    public static final String SQLSERVER_VARCHAR = "VARCHAR";
    public static final String SQLSERVER_NCHAR = "NCHAR";
    public static final String SQLSERVER_NVARCHAR = "NVARCHAR";
    public static final String SQLSERVER_TEXT = "TEXT";
    public static final String SQLSERVER_NTEXT = "NTEXT";
    public static final String SQLSERVER_XML = "XML";
    public static final String SQLSERVER_UNIQUEIDENTIFIER = "UNIQUEIDENTIFIER";
    public static final String SQLSERVER_SQLVARIANT = "SQL_VARIANT";
    public static final String SQLSERVER_DATE = "DATE";
    public static final String SQLSERVER_TIME = "TIME";
    public static final String SQLSERVER_DATETIME = "DATETIME";
    public static final String SQLSERVER_DATETIME2 = "DATETIME2";
    public static final String SQLSERVER_SMALLDATETIME = "SMALLDATETIME";
    public static final String SQLSERVER_DATETIMEOFFSET = "DATETIMEOFFSET";
    public static final String SQLSERVER_TIMESTAMP = "TIMESTAMP";
    public static final String SQLSERVER_BINARY = "BINARY";
    public static final String SQLSERVER_VARBINARY = "VARBINARY";
    public static final String SQLSERVER_IMAGE = "IMAGE";
    public static final int MAX_PRECISION = 38;
    public static final int DEFAULT_PRECISION = 38;
    public static final int MAX_SCALE = 37;
    public static final int DEFAULT_SCALE = 18;
    public static final int MAX_CHAR_LENGTH = 8000;
    public static final int MAX_NVARCHAR_LENGTH = 4000;
    public static final int MAX_BINARY_LENGTH = 8000;
    public static final int MAX_TIME_SCALE = 7;
    public static final int MAX_TIMESTAMP_SCALE = 7;
    public static final String MAX_VARBINARY = String.format("%s(%s)", "VARBINARY", "MAX");
    public static final String MAX_VARCHAR = String.format("%s(%s)", "VARCHAR", "MAX");
    public static final String MAX_NVARCHAR = String.format("%s(%s)", "NVARCHAR", "MAX");
    public static final long POWER_2_30 = (long)Math.pow(2.0, 30.0);
    public static final long POWER_2_31 = (long)Math.pow(2.0, 31.0);
    public static final SqlServerTypeConverter INSTANCE = new SqlServerTypeConverter();

    public String identifier() {
        return "SqlServer";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        String sqlServerType;
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        switch (sqlServerType = typeDefine.getDataType().toUpperCase()) {
            case "BIT": {
                builder.sourceType(SQLSERVER_BIT);
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "TINYINT": 
            case "TINYINT IDENTITY": {
                builder.sourceType(SQLSERVER_TINYINT);
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "SMALLINT": 
            case "SMALLINT IDENTITY": {
                builder.sourceType(SQLSERVER_SMALLINT);
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "INTEGER": 
            case "INTEGER IDENTITY": 
            case "INT": 
            case "INT IDENTITY": {
                builder.sourceType(SQLSERVER_INT);
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "BIGINT": 
            case "BIGINT IDENTITY": {
                builder.sourceType(SQLSERVER_BIGINT);
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "REAL": {
                builder.sourceType(SQLSERVER_REAL);
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "FLOAT": {
                if (typeDefine.getPrecision() != null && typeDefine.getPrecision() <= 24L) {
                    builder.sourceType(SQLSERVER_REAL);
                    builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                    break;
                }
                builder.sourceType(SQLSERVER_FLOAT);
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "DECIMAL": 
            case "NUMERIC": {
                builder.sourceType(String.format("%s(%s,%s)", SQLSERVER_DECIMAL, typeDefine.getPrecision(), typeDefine.getScale()));
                builder.dataType((SeaTunnelDataType)new DecimalType(typeDefine.getPrecision().intValue(), typeDefine.getScale().intValue()));
                builder.columnLength(typeDefine.getPrecision());
                builder.scale(typeDefine.getScale());
                break;
            }
            case "MONEY": {
                builder.sourceType(SQLSERVER_MONEY);
                builder.dataType((SeaTunnelDataType)new DecimalType(typeDefine.getPrecision().intValue(), typeDefine.getScale().intValue()));
                builder.columnLength(typeDefine.getPrecision());
                builder.scale(typeDefine.getScale());
                break;
            }
            case "SMALLMONEY": {
                builder.sourceType(SQLSERVER_SMALLMONEY);
                builder.dataType((SeaTunnelDataType)new DecimalType(typeDefine.getPrecision().intValue(), typeDefine.getScale().intValue()));
                builder.columnLength(typeDefine.getPrecision());
                builder.scale(typeDefine.getScale());
                break;
            }
            case "CHAR": {
                builder.sourceType(String.format("%s(%s)", SQLSERVER_CHAR, typeDefine.getLength()));
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(TypeDefineUtils.doubleByteTo4ByteLength(typeDefine.getLength()));
                break;
            }
            case "NCHAR": {
                builder.sourceType(String.format("%s(%s)", SQLSERVER_NCHAR, typeDefine.getLength()));
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(TypeDefineUtils.doubleByteTo4ByteLength(typeDefine.getLength()));
                break;
            }
            case "VARCHAR": {
                if (typeDefine.getLength() == -1L) {
                    builder.sourceType(MAX_VARCHAR);
                    builder.columnLength(TypeDefineUtils.doubleByteTo4ByteLength(POWER_2_31 - 1L));
                } else {
                    builder.sourceType(String.format("%s(%s)", SQLSERVER_VARCHAR, typeDefine.getLength()));
                    builder.columnLength(TypeDefineUtils.doubleByteTo4ByteLength(typeDefine.getLength()));
                }
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "NVARCHAR": {
                if (typeDefine.getLength() == -1L) {
                    builder.sourceType(MAX_NVARCHAR);
                    builder.columnLength(TypeDefineUtils.doubleByteTo4ByteLength(POWER_2_31 - 1L));
                } else {
                    builder.sourceType(String.format("%s(%s)", SQLSERVER_NVARCHAR, typeDefine.getLength()));
                    builder.columnLength(TypeDefineUtils.doubleByteTo4ByteLength(typeDefine.getLength()));
                }
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case "TEXT": {
                builder.sourceType(SQLSERVER_TEXT);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(POWER_2_31 - 1L));
                break;
            }
            case "NTEXT": {
                builder.sourceType(SQLSERVER_NTEXT);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(POWER_2_30 - 1L));
                break;
            }
            case "XML": {
                builder.sourceType(SQLSERVER_XML);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(Long.valueOf(POWER_2_31 - 1L));
                break;
            }
            case "UNIQUEIDENTIFIER": {
                builder.sourceType(SQLSERVER_UNIQUEIDENTIFIER);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(TypeDefineUtils.charTo4ByteLength(typeDefine.getLength()));
                break;
            }
            case "SQL_VARIANT": {
                builder.sourceType(SQLSERVER_SQLVARIANT);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "BINARY": {
                builder.sourceType(String.format("%s(%s)", SQLSERVER_BINARY, typeDefine.getLength()));
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "VARBINARY": {
                if (typeDefine.getLength() == -1L) {
                    builder.sourceType(MAX_VARBINARY);
                    builder.columnLength(Long.valueOf(POWER_2_31 - 1L));
                } else {
                    builder.sourceType(String.format("%s(%s)", SQLSERVER_VARBINARY, typeDefine.getLength()));
                    builder.columnLength(typeDefine.getLength());
                }
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                break;
            }
            case "IMAGE": {
                builder.sourceType(SQLSERVER_IMAGE);
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(POWER_2_31 - 1L));
                break;
            }
            case "TIMESTAMP": {
                builder.sourceType(SQLSERVER_TIMESTAMP);
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(Long.valueOf(8L));
                break;
            }
            case "DATE": {
                builder.sourceType(SQLSERVER_DATE);
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case "TIME": {
                builder.sourceType(String.format("%s(%s)", SQLSERVER_TIME, typeDefine.getScale()));
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            case "DATETIME": {
                builder.sourceType(SQLSERVER_DATETIME);
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(Integer.valueOf(3));
                break;
            }
            case "DATETIME2": {
                builder.sourceType(String.format("%s(%s)", SQLSERVER_DATETIME2, typeDefine.getScale()));
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            case "DATETIMEOFFSET": {
                builder.sourceType(String.format("%s(%s)", SQLSERVER_DATETIMEOFFSET, typeDefine.getScale()));
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            case "SMALLDATETIME": {
                builder.sourceType(SQLSERVER_SMALLDATETIME);
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)"SqlServer", (String)sqlServerType, (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case BOOLEAN: {
                builder.columnType(SQLSERVER_BIT);
                builder.dataType(SQLSERVER_BIT);
                break;
            }
            case TINYINT: {
                builder.columnType(SQLSERVER_TINYINT);
                builder.dataType(SQLSERVER_TINYINT);
                break;
            }
            case SMALLINT: {
                builder.columnType(SQLSERVER_SMALLINT);
                builder.dataType(SQLSERVER_SMALLINT);
                break;
            }
            case INT: {
                builder.columnType(SQLSERVER_INT);
                builder.dataType(SQLSERVER_INT);
                break;
            }
            case BIGINT: {
                builder.columnType(SQLSERVER_BIGINT);
                builder.dataType(SQLSERVER_BIGINT);
                break;
            }
            case FLOAT: {
                builder.columnType(SQLSERVER_REAL);
                builder.dataType(SQLSERVER_REAL);
                break;
            }
            case DOUBLE: {
                builder.columnType(SQLSERVER_FLOAT);
                builder.dataType(SQLSERVER_FLOAT);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0L) {
                    precision = 38L;
                    scale = 18;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 38L) {
                    scale = (int)Math.max(0L, (long)scale - (precision - 38L));
                    precision = 38L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 38, precision, scale});
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 37) {
                    scale = 37;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 37, precision, scale});
                }
                builder.columnType(String.format("%s(%s,%s)", SQLSERVER_DECIMAL, precision, scale));
                builder.dataType(SQLSERVER_DECIMAL);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case STRING: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(MAX_NVARCHAR);
                    builder.dataType(MAX_NVARCHAR);
                    break;
                }
                if (column.getColumnLength() <= 4000L) {
                    builder.columnType(String.format("%s(%s)", SQLSERVER_NVARCHAR, column.getColumnLength()));
                    builder.dataType(SQLSERVER_NVARCHAR);
                    builder.length(column.getColumnLength());
                    break;
                }
                builder.columnType(MAX_NVARCHAR);
                builder.dataType(MAX_NVARCHAR);
                builder.length(column.getColumnLength());
                break;
            }
            case BYTES: {
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(MAX_VARBINARY);
                    builder.dataType(SQLSERVER_VARBINARY);
                    break;
                }
                if (column.getColumnLength() <= 8000L) {
                    builder.columnType(String.format("%s(%s)", SQLSERVER_VARBINARY, column.getColumnLength()));
                    builder.dataType(SQLSERVER_VARBINARY);
                    builder.length(column.getColumnLength());
                    break;
                }
                builder.columnType(MAX_VARBINARY);
                builder.dataType(SQLSERVER_VARBINARY);
                builder.length(column.getColumnLength());
                break;
            }
            case DATE: {
                builder.columnType(SQLSERVER_DATE);
                builder.dataType(SQLSERVER_DATE);
                break;
            }
            case TIME: {
                if (column.getScale() != null && column.getScale() > 0) {
                    int timeScale = column.getScale();
                    if (timeScale > 7) {
                        timeScale = 7;
                        log.warn("The time column {} type time({}) is out of range, which exceeds the maximum scale of {}, it will be converted to time({})", new Object[]{column.getName(), column.getScale(), 37, timeScale});
                    }
                    builder.columnType(String.format("%s(%s)", SQLSERVER_TIME, timeScale));
                    builder.scale(Integer.valueOf(timeScale));
                } else {
                    builder.columnType(SQLSERVER_TIME);
                }
                builder.dataType(SQLSERVER_TIME);
                break;
            }
            case TIMESTAMP: {
                if (column.getScale() != null && column.getScale() > 0) {
                    int timestampScale = column.getScale();
                    if (timestampScale > 7) {
                        timestampScale = 7;
                        log.warn("The timestamp column {} type timestamp({}) is out of range, which exceeds the maximum scale of {}, it will be converted to timestamp({})", new Object[]{column.getName(), column.getScale(), 7, timestampScale});
                    }
                    builder.columnType(String.format("%s(%s)", SQLSERVER_DATETIME2, timestampScale));
                    builder.scale(Integer.valueOf(timestampScale));
                } else {
                    builder.columnType(SQLSERVER_DATETIME2);
                }
                builder.dataType(SQLSERVER_DATETIME2);
                break;
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)"SqlServer", (String)column.getDataType().getSqlType().name(), (String)column.getName());
            }
        }
        return builder.build();
    }
}

