/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.dm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCatalog;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.dm.DamengCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dm.DmdbTypeConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dm.DmdbTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamengCatalog
extends AbstractJdbcCatalog {
    private static final Logger log = LoggerFactory.getLogger(DamengCatalog.class);
    private static final String SELECT_COLUMNS_SQL = "SELECT COLUMNS.COLUMN_NAME, COLUMNS.DATA_TYPE, COLUMNS.DATA_LENGTH, COLUMNS.DATA_PRECISION, COLUMNS.DATA_SCALE , COLUMNS.NULLABLE, COLUMNS.DATA_DEFAULT, COMMENTS.COMMENTS ,CASE \n        WHEN COLUMNS.DATA_TYPE IN ('CHAR', 'CHARACTER', 'VARCHAR', 'VARCHAR2', 'VARBINARY', 'BINARY') THEN COLUMNS.DATA_TYPE || '(' || COLUMNS.DATA_LENGTH || ')'\n        WHEN COLUMNS.DATA_TYPE IN ('NUMERIC', 'DECIMAL', 'NUMBER') AND COLUMNS.DATA_PRECISION IS NOT NULL AND COLUMNS.DATA_SCALE IS NOT NULL AND COLUMNS.DATA_PRECISION != 0 AND COLUMNS.DATA_SCALE != 0 THEN COLUMNS.DATA_TYPE || '(' || COLUMNS.DATA_PRECISION || ', ' || COLUMNS.DATA_SCALE || ')'\n        ELSE COLUMNS.DATA_TYPE\n    END AS SOURCE_TYPE \nFROM ALL_TAB_COLUMNS COLUMNS LEFT JOIN ALL_COL_COMMENTS COMMENTS ON COLUMNS.OWNER = COMMENTS.SCHEMA_NAME AND COLUMNS.TABLE_NAME = COMMENTS.TABLE_NAME AND COLUMNS.COLUMN_NAME = COMMENTS.COLUMN_NAME WHERE COLUMNS.OWNER = '%s' AND COLUMNS.TABLE_NAME = '%s' ORDER BY COLUMNS.COLUMN_ID ASC";

    public DamengCatalog(String catalogName, String username, String pwd, JdbcUrlUtil.UrlInfo urlInfo, String defaultSchema) {
        super(catalogName, username, pwd, urlInfo, defaultSchema);
    }

    @Override
    protected void createDatabaseInternal(String databaseName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dropDatabaseInternal(String databaseName) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getExistDataSql(TablePath tablePath) {
        return String.format("select * from \"%s\".\"%s\" LIMIT 1", tablePath.getSchemaName(), tablePath.getTableName());
    }

    @Override
    protected String getDatabaseWithConditionSql(String databaseName) {
        return String.format(this.getListDatabaseSql() + " where name = '%s'", databaseName);
    }

    @Override
    protected String getTableWithConditionSql(TablePath tablePath) {
        return String.format(this.getListTableSql(tablePath.getDatabaseName()) + " where OWNER = '%s' and TABLE_NAME = '%s'", tablePath.getSchemaName(), tablePath.getTableName());
    }

    @Override
    protected String getListDatabaseSql() {
        return "SELECT name FROM v$database";
    }

    @Override
    protected String getCreateTableSql(TablePath tablePath, CatalogTable table, boolean createIndex) {
        return new DamengCreateTableSqlBuilder(table, createIndex).build(tablePath);
    }

    @Override
    protected String getDropTableSql(TablePath tablePath) {
        return String.format("DROP TABLE %s", this.getTableName(tablePath));
    }

    @Override
    protected String getTableName(TablePath tablePath) {
        return tablePath.getSchemaAndTableName("\"");
    }

    @Override
    protected String getListTableSql(String databaseName) {
        return "SELECT OWNER, TABLE_NAME FROM ALL_TABLES";
    }

    @Override
    protected String getTableName(ResultSet rs) throws SQLException {
        return rs.getString(1) + "." + rs.getString(2);
    }

    @Override
    protected String getSelectColumnsSql(TablePath tablePath) {
        return String.format(SELECT_COLUMNS_SQL, tablePath.getSchemaName(), tablePath.getTableName());
    }

    @Override
    protected String getTruncateTableSql(TablePath tablePath) {
        return String.format("TRUNCATE TABLE \"%s\".\"%s\"", tablePath.getSchemaName(), tablePath.getTableName());
    }

    @Override
    protected Column buildColumn(ResultSet resultSet) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String typeName = resultSet.getString("DATA_TYPE");
        long columnLength = resultSet.getLong("DATA_LENGTH");
        long columnPrecision = resultSet.getLong("DATA_PRECISION");
        int columnScale = resultSet.getInt("DATA_SCALE");
        String columnComment = resultSet.getString("COMMENTS");
        Object defaultValue = resultSet.getObject("DATA_DEFAULT");
        boolean isNullable = resultSet.getString("NULLABLE").equals("Y");
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(columnName).columnType(typeName).dataType(typeName).length(Long.valueOf(columnLength)).precision(Long.valueOf(columnPrecision)).scale(Integer.valueOf(columnScale)).nullable(isNullable).defaultValue(defaultValue).comment(columnComment).build();
        return DmdbTypeConverter.INSTANCE.convert(typeDefine);
    }

    @Override
    protected String getUrlFromDatabaseName(String databaseName) {
        return this.defaultUrl;
    }

    @Override
    protected String getOptionTableName(TablePath tablePath) {
        return tablePath.getSchemaAndTableName();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        try (PreparedStatement ps = this.getConnection(this.defaultUrl).prepareStatement("SELECT OWNER, TABLE_NAME FROM ALL_TABLES");){
            ArrayList<String> arrayList;
            block16: {
                ResultSet rs = ps.executeQuery();
                try {
                    ArrayList<String> tables = new ArrayList<String>();
                    while (rs.next()) {
                        tables.add(rs.getString(1) + "." + rs.getString(2));
                    }
                    arrayList = tables;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed listing table in catalog %s", this.catalogName), (Throwable)e);
        }
    }

    @Override
    public CatalogTable getTable(String sqlQuery) throws SQLException {
        Connection defaultConnection = this.getConnection(this.defaultUrl);
        return CatalogUtils.getCatalogTable(defaultConnection, sqlQuery, (JdbcDialectTypeMapper)new DmdbTypeMapper());
    }
}

