/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.sqlserver.LegacyV1SqlServerSourceInfoStructMaker;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SourceTimestampMode;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerSourceInfoStructMaker;
import io.debezium.document.Document;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecordComparator;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnectorConfig.class);
    public static final String SOURCE_TIMESTAMP_MODE_CONFIG_NAME = "source.timestamp.mode";
    public static final String MAX_TRANSACTIONS_PER_ITERATION_CONFIG_NAME = "max.iteration.transactions";
    protected static final int DEFAULT_PORT = 1433;
    protected static final int DEFAULT_MAX_TRANSACTIONS_PER_ITERATION = 0;
    private static final String READ_ONLY_INTENT = "ReadOnly";
    private static final String APPLICATION_INTENT_KEY = "database.applicationIntent";
    public static final Field USER = RelationalDatabaseConnectorConfig.USER.optional().withNoValidation();
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(1433);
    public static final Field SERVER_NAME = RelationalDatabaseConnectorConfig.SERVER_NAME.withValidation(CommonConnectorConfig::validateServerNameIsDifferentFromHistoryTopicName);
    public static final Field INSTANCE = Field.create("database.instance").withDisplayName("Instance name").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry(Field.Group.CONNECTION, 8)).withImportance(ConfigDef.Importance.LOW).withValidation(Field::isOptional).withDescription("The SQL Server instance name");
    public static final Field DATABASE_NAME = RelationalDatabaseConnectorConfig.DATABASE_NAME.withNoValidation().withValidation(SqlServerConnectorConfig::validateDatabaseName);
    public static final Field DATABASE_NAMES = Field.create("database.names").withDisplayName("Databases").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry(Field.Group.CONNECTION, 7)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(SqlServerConnectorConfig::validateDatabaseNames).withDescription("The names of the databases from which the connector should capture changes");
    @Deprecated
    public static final Field SERVER_TIMEZONE = Field.create("database.server.timezone").withDisplayName("Server timezone").withType(ConfigDef.Type.STRING).withImportance(ConfigDef.Importance.LOW).withValidation((config, field, problems) -> {
        String value = config.getString(field);
        if (value != null) {
            try {
                ZoneId.of(value, ZoneId.SHORT_IDS);
            }
            catch (DateTimeException e) {
                problems.accept(field, value, "The value must be a valid ZoneId");
                return 1;
            }
        }
        return 0;
    }).withDescription("The timezone of the server used to correctly shift the commit transaction timestamp on the client sideOptions include: Any valid Java ZoneId (deprecated, the connector will determine the database server timezone offset automatically)");
    public static final Field MAX_LSN_OPTIMIZATION = Field.createInternal("streaming.lsn.optimization").withDisplayName("Max LSN Optimization").withDefault(true).withType(ConfigDef.Type.BOOLEAN).withImportance(ConfigDef.Importance.LOW).withDescription("This property can be used to enable/disable an optimization that prevents querying the cdc tables on LSNs not correlated to changes.");
    public static final Field MAX_TRANSACTIONS_PER_ITERATION = Field.create("max.iteration.transactions").withDisplayName("Max transactions per iteration").withDefault(0).withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_ADVANCED, 1)).withImportance(ConfigDef.Importance.MEDIUM).withValidation(Field::isNonNegativeInteger).withDescription("This property can be used to reduce the connector memory usage footprint when changes are streamed from multiple tables per database.");
    public static final Field SOURCE_TIMESTAMP_MODE = Field.create("source.timestamp.mode").withDisplayName("Source timestamp mode").withDefault(SourceTimestampMode.COMMIT.getValue()).withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_ADVANCED, 0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Configures the criteria of the attached timestamp within the source record (ts_ms).Options include:'" + SourceTimestampMode.COMMIT.getValue() + "', (default) the source timestamp is set to the instant where the record was committed in the database'" + SourceTimestampMode.PROCESSING.getValue() + "', (deprecated) the source timestamp is set to the instant where the record was processed by Debezium.");
    public static final Field SNAPSHOT_MODE = Field.create("snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, SnapshotMode.INITIAL).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_SNAPSHOT, 0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name. ");
    public static final Field SNAPSHOT_ISOLATION_MODE = Field.create("snapshot.isolation.mode").withDisplayName("Snapshot isolation mode").withEnum(SnapshotIsolationMode.class, SnapshotIsolationMode.REPEATABLE_READ).withGroup(Field.createGroupEntry(Field.Group.CONNECTOR_SNAPSHOT, 1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls which transaction isolation level is used and how long the connector locks the monitored tables. The default is '" + SnapshotIsolationMode.REPEATABLE_READ.getValue() + "', which means that repeatable read isolation level is used. In addition, exclusive locks are taken only during schema snapshot. Using a value of '" + SnapshotIsolationMode.EXCLUSIVE.getValue() + "' ensures that the connector holds the exclusive lock (and thus prevents any reads and updates) for all monitored tables during the entire snapshot duration. When '" + SnapshotIsolationMode.SNAPSHOT.getValue() + "' is specified, connector runs the initial snapshot in SNAPSHOT isolation level, which guarantees snapshot consistency. In addition, neither table nor row-level locks are held. When '" + SnapshotIsolationMode.READ_COMMITTED.getValue() + "' is specified, connector runs the initial snapshot in READ COMMITTED isolation level. No long-running locks are taken, so that initial snapshot does not prevent other transactions from updating table rows. Snapshot consistency is not guaranteed.In '" + SnapshotIsolationMode.READ_UNCOMMITTED.getValue() + "' mode neither table nor row-level locks are acquired, but connector does not guarantee snapshot consistency.");
    public static final Field INCREMENTAL_SNAPSHOT_OPTION_RECOMPILE = Field.create("incremental.snapshot.option.recompile").withDisplayName("Recompile SELECT statements").withDefault(false).withType(ConfigDef.Type.BOOLEAN).withImportance(ConfigDef.Importance.LOW).withValidation(Field::isBoolean).withDescription("Add OPTION(RECOMPILE) on each SELECT statement during the incremental snapshot process. This prevents parameter sniffing but can cause CPU pressure on the source database.");
    private static final ConfigDefinition CONFIG_DEFINITION = HistorizedRelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("SQL Server").type(DATABASE_NAME, DATABASE_NAMES, HOSTNAME, PORT, USER, PASSWORD, SERVER_TIMEZONE, INSTANCE).connector(SNAPSHOT_MODE, SNAPSHOT_ISOLATION_MODE, SOURCE_TIMESTAMP_MODE, MAX_TRANSACTIONS_PER_ITERATION, BINARY_HANDLING_MODE, SCHEMA_NAME_ADJUSTMENT_MODE, INCREMENTAL_SNAPSHOT_OPTION_RECOMPILE, INCREMENTAL_SNAPSHOT_CHUNK_SIZE, INCREMENTAL_SNAPSHOT_ALLOW_SCHEMA_CHANGES).excluding(SCHEMA_WHITELIST, SCHEMA_INCLUDE_LIST, SCHEMA_BLACKLIST, SCHEMA_EXCLUDE_LIST).create();
    public static Field.Set ALL_FIELDS = Field.setOf(CONFIG_DEFINITION.all());
    private final List<String> databaseNames;
    private final String instanceName;
    private final SnapshotMode snapshotMode;
    private final SnapshotIsolationMode snapshotIsolationMode;
    private final SourceTimestampMode sourceTimestampMode;
    private final boolean readOnlyDatabaseConnection;
    private final int maxTransactionsPerIteration;
    private final boolean multiPartitionMode;
    private final boolean optionRecompile;

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public SqlServerConnectorConfig(Configuration config) {
        super(SqlServerConnector.class, config, config.getString(SERVER_NAME), (Tables.TableFilter)new SystemTablesPredicate(), x -> x.schema() + "." + x.table(), true, ColumnFilterMode.SCHEMA, config.hasKey(DATABASE_NAMES));
        String databaseName = config.getString(DATABASE_NAME.name());
        String databaseNames = config.getString(DATABASE_NAMES.name());
        if (databaseName != null) {
            this.multiPartitionMode = false;
            this.databaseNames = Collections.singletonList(databaseName);
        } else if (databaseNames != null) {
            this.multiPartitionMode = true;
            this.databaseNames = Arrays.asList(databaseNames.split(","));
            LOGGER.info("Multi-partition mode is enabled");
        } else {
            this.multiPartitionMode = false;
            this.databaseNames = Collections.emptyList();
        }
        this.instanceName = config.getString(INSTANCE);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE), SNAPSHOT_MODE.defaultValueAsString());
        this.readOnlyDatabaseConnection = READ_ONLY_INTENT.equals(config.getString(APPLICATION_INTENT_KEY));
        if (this.readOnlyDatabaseConnection) {
            this.snapshotIsolationMode = SnapshotIsolationMode.SNAPSHOT;
            LOGGER.info("JDBC connection has set applicationIntent = ReadOnly, switching snapshot isolation mode to {}", (Object)SnapshotIsolationMode.SNAPSHOT.name());
        } else {
            this.snapshotIsolationMode = SnapshotIsolationMode.parse(config.getString(SNAPSHOT_ISOLATION_MODE), SNAPSHOT_ISOLATION_MODE.defaultValueAsString());
        }
        this.sourceTimestampMode = SourceTimestampMode.fromMode(config.getString(SOURCE_TIMESTAMP_MODE_CONFIG_NAME));
        this.maxTransactionsPerIteration = config.getInteger(MAX_TRANSACTIONS_PER_ITERATION);
        if (!config.getBoolean(MAX_LSN_OPTIMIZATION)) {
            LOGGER.warn("The option '{}' is no longer taken into account. The optimization is always enabled.", (Object)MAX_LSN_OPTIMIZATION.name());
        }
        this.optionRecompile = config.getBoolean(INCREMENTAL_SNAPSHOT_OPTION_RECOMPILE);
    }

    public List<String> getDatabaseNames() {
        return this.databaseNames;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public boolean isMultiPartitionModeEnabled() {
        return this.multiPartitionMode;
    }

    public SnapshotIsolationMode getSnapshotIsolationMode() {
        return this.snapshotIsolationMode;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public SourceTimestampMode getSourceTimestampMode() {
        return this.sourceTimestampMode;
    }

    public boolean isReadOnlyDatabaseConnection() {
        return this.readOnlyDatabaseConnection;
    }

    public int getMaxTransactionsPerIteration() {
        return this.maxTransactionsPerIteration;
    }

    public boolean getOptionRecompile() {
        return this.optionRecompile;
    }

    @Override
    public boolean supportsOperationFiltering() {
        return true;
    }

    @Override
    protected boolean supportsSchemaChangesDuringIncrementalSnapshot() {
        return true;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        switch (version) {
            case V1: {
                return new LegacyV1SqlServerSourceInfoStructMaker(Module.name(), Module.version(), this);
            }
        }
        return new SqlServerSourceInfoStructMaker(Module.name(), Module.version(), this);
    }

    @Override
    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            @Override
            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return Lsn.valueOf(recorded.getString("change_lsn")).compareTo(Lsn.valueOf(desired.getString("change_lsn"))) < 1;
            }
        };
    }

    @Override
    public String getContextName() {
        return Module.contextName();
    }

    @Override
    public String getConnectorName() {
        return Module.name();
    }

    private static int validateDatabaseName(Configuration config, Field field, Field.ValidationOutput problems) {
        if (!config.hasKey(field) && !config.hasKey(DATABASE_NAMES)) {
            problems.accept(field, null, "Either " + DATABASE_NAME + " or " + DATABASE_NAMES + " must be specified");
            return 1;
        }
        return 0;
    }

    private static int validateDatabaseNames(Configuration config, Field field, Field.ValidationOutput problems) {
        String databaseNames = config.getString(field);
        int count = 0;
        if (databaseNames != null) {
            if (config.hasKey(DATABASE_NAME)) {
                problems.accept(field, null, "Cannot be specified alongside " + DATABASE_NAME);
                ++count;
            }
            if (databaseNames.split(",").length == 0) {
                problems.accept(field, databaseNames, "Cannot be empty");
                ++count;
            }
        }
        return count;
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        private SystemTablesPredicate() {
        }

        @Override
        public boolean isIncluded(TableId t) {
            return t.schema() != null && !t.schema().toLowerCase().equals("cdc") && !t.schema().toLowerCase().equals("sys") && !t.table().toLowerCase().equals("systranschemas");
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true),
        INITIAL_ONLY("initial_only", true),
        SCHEMA_ONLY("schema_only", false);

        private final String value;
        private final boolean includeData;

        private SnapshotMode(String value, boolean includeData) {
            this.value = value;
            this.includeData = includeData;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean includeData() {
            return this.includeData;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotIsolationMode implements EnumeratedValue
    {
        EXCLUSIVE("exclusive"),
        SNAPSHOT("snapshot"),
        REPEATABLE_READ("repeatable_read"),
        READ_COMMITTED("read_committed"),
        READ_UNCOMMITTED("read_uncommitted");

        private final String value;

        private SnapshotIsolationMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static SnapshotIsolationMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotIsolationMode option : SnapshotIsolationMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotIsolationMode parse(String value, String defaultValue) {
            SnapshotIsolationMode mode = SnapshotIsolationMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotIsolationMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

