/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect;

import java.util.LinkedList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.GenericDialectFactory;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcDialectLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDialectLoader.class);

    private JdbcDialectLoader() {
    }

    public static JdbcDialect load(String url, String dialect, String compatibleMode) {
        return JdbcDialectLoader.load(url, compatibleMode, dialect, "", null);
    }

    public static JdbcDialect load(String url, String dialect, String compatibleMode, JdbcConnectionConfig jdbcConnectionConfig) {
        return JdbcDialectLoader.load(url, compatibleMode, dialect, "", jdbcConnectionConfig);
    }

    public static JdbcDialect load(String url, String compatibleMode, String dialect, String fieldIde) {
        return JdbcDialectLoader.load(url, compatibleMode, dialect, fieldIde, null);
    }

    public static JdbcDialect load(String url, String compatibleMode, String dialect, String fieldIde, JdbcConnectionConfig jdbcConnectionConfig) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List<JdbcDialectFactory> foundFactories = JdbcDialectLoader.discoverFactories(cl);
        if (foundFactories.isEmpty()) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)JdbcConnectorErrorCode.NO_SUITABLE_DIALECT_FACTORY, String.format("Could not find any jdbc dialect factories that implement '%s' in the classpath.", JdbcDialectFactory.class.getName()));
        }
        List matchingFactories = dialect != null ? foundFactories.stream().filter(f -> f.dialectFactoryName().equalsIgnoreCase(dialect)).collect(Collectors.toList()) : foundFactories.stream().filter(f -> f.acceptsURL(url)).collect(Collectors.toList());
        if (matchingFactories.size() > 1) {
            matchingFactories = matchingFactories.stream().filter(f -> !(f instanceof GenericDialectFactory)).collect(Collectors.toList());
        }
        if (matchingFactories.size() > 1) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)JdbcConnectorErrorCode.NO_SUITABLE_DIALECT_FACTORY, String.format("Multiple jdbc dialect factories can handle url '%s' that implement '%s' found in the classpath.\n\nAmbiguous factory classes are:\n\n%s", url, JdbcDialectFactory.class.getName(), matchingFactories.stream().map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
        }
        return ((JdbcDialectFactory)matchingFactories.get(0)).create(compatibleMode, fieldIde, jdbcConnectionConfig);
    }

    private static List<JdbcDialectFactory> discoverFactories(ClassLoader classLoader) {
        try {
            LinkedList<JdbcDialectFactory> result = new LinkedList<JdbcDialectFactory>();
            ServiceLoader.load(JdbcDialectFactory.class, classLoader).iterator().forEachRemaining(result::add);
            return result;
        }
        catch (ServiceConfigurationError e) {
            LOG.error("Could not load service provider for jdbc dialects factory.", (Throwable)e);
            throw new JdbcConnectorException(JdbcConnectorErrorCode.NO_SUITABLE_DIALECT_FACTORY, "Could not load service provider for jdbc dialects factory.", e);
        }
    }
}

