/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class GenericTypeConverter
implements TypeConverter<BasicTypeDefine> {
    private static final Logger log = LoggerFactory.getLogger(GenericTypeConverter.class);
    public static final GenericTypeConverter DEFAULT_INSTANCE = new GenericTypeConverter();
    public static final int MAX_PRECISION = 65;
    public static final int DEFAULT_PRECISION = 38;
    public static final int MAX_SCALE = 64;
    public static final int DEFAULT_SCALE = 18;

    public String identifier() {
        return "Generic";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        int sqlType = typeDefine.getSqlType();
        switch (sqlType) {
            case 0: {
                builder.dataType((SeaTunnelDataType)BasicType.VOID_TYPE);
                break;
            }
            case 16: {
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case -7: {
                if (typeDefine.getLength() == null || typeDefine.getLength() <= 0L || typeDefine.getLength() == 1L) {
                    builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                    break;
                }
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                long byteLength = typeDefine.getLength() / 8L;
                builder.columnLength(Long.valueOf(byteLength += typeDefine.getLength() % 8L > 0L ? 1L : 0L));
                break;
            }
            case -6: {
                builder.dataType((SeaTunnelDataType)BasicType.BYTE_TYPE);
                break;
            }
            case 5: {
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case 4: {
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case -5: {
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case 6: 
            case 7: {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case 8: {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case 2: {
                DecimalType decimalTypeForNumeric = typeDefine.getPrecision() != null && typeDefine.getPrecision() > 0L ? new DecimalType(typeDefine.getPrecision().intValue(), typeDefine.getScale().intValue()) : new DecimalType(38, 18);
                builder.dataType((SeaTunnelDataType)decimalTypeForNumeric);
                break;
            }
            case 3: {
                Preconditions.checkArgument((typeDefine.getPrecision() > 0L ? 1 : 0) != 0);
                DecimalType decimalType = typeDefine.getPrecision() > 38L ? new DecimalType(38, 18) : new DecimalType(typeDefine.getPrecision().intValue(), typeDefine.getScale() == null ? 0 : typeDefine.getScale());
                builder.dataType((SeaTunnelDataType)decimalType);
                builder.columnLength(Long.valueOf(decimalType.getPrecision()));
                builder.scale(Integer.valueOf(decimalType.getScale()));
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (typeDefine.getLength() == null || typeDefine.getLength() <= 0L) {
                    builder.columnLength(Long.valueOf(1L));
                } else {
                    builder.columnLength(typeDefine.getLength());
                }
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                break;
            }
            case 91: {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case 92: {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            case 93: {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            default: {
                log.warn("JDBC type {} ({}) not currently supported", (Object)sqlType, typeDefine.getNativeType());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine reconvert(Column column) {
        throw new UnsupportedOperationException(String.format("%s (%s) type doesn't have a mapping to the SQL database column type", column.getName(), column.getDataType().getSqlType().name()));
    }
}

