/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.dm;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.AbstractJdbcCreateTableSqlBuilder;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dm.DmdbTypeConverter;

public class DamengCreateTableSqlBuilder
extends AbstractJdbcCreateTableSqlBuilder {
    private final List<Column> columns;
    private final PrimaryKey primaryKey;
    private final String sourceCatalogName;
    private final String fieldIde;
    private final List<ConstraintKey> constraintKeys;
    private boolean createIndex;

    public DamengCreateTableSqlBuilder(CatalogTable catalogTable, boolean createIndex) {
        this.columns = catalogTable.getTableSchema().getColumns();
        this.primaryKey = catalogTable.getTableSchema().getPrimaryKey();
        this.sourceCatalogName = catalogTable.getCatalogName();
        this.fieldIde = (String)catalogTable.getOptions().get("fieldIde");
        this.constraintKeys = catalogTable.getTableSchema().getConstraintKeys();
        this.createIndex = createIndex;
    }

    public String build(TablePath tablePath) {
        StringBuilder createTableSql = new StringBuilder();
        createTableSql.append("CREATE TABLE ").append(tablePath.getSchemaAndTableName("\"")).append(" (\n");
        List columnSqls = this.columns.stream().map(column -> CatalogUtils.getFieldIde(this.buildColumnSql((Column)column), this.fieldIde)).collect(Collectors.toList());
        if (this.createIndex && this.primaryKey != null && CollectionUtils.isNotEmpty((Collection)this.primaryKey.getColumnNames())) {
            columnSqls.add(this.buildPrimaryKeySql(this.primaryKey));
        }
        if (this.createIndex && CollectionUtils.isNotEmpty(this.constraintKeys)) {
            for (ConstraintKey constraintKey : this.constraintKeys) {
                String constraintKeySql;
                if (StringUtils.isBlank((CharSequence)constraintKey.getConstraintName()) || this.primaryKey != null && (StringUtils.equals((CharSequence)this.primaryKey.getPrimaryKey(), (CharSequence)constraintKey.getConstraintName()) || this.primaryContainsAllConstrainKey(this.primaryKey, constraintKey)) || !StringUtils.isNotEmpty((CharSequence)(constraintKeySql = this.buildConstraintKeySql(constraintKey)))) continue;
                columnSqls.add("\t" + constraintKeySql);
            }
        }
        createTableSql.append(String.join((CharSequence)",\n", columnSqls));
        createTableSql.append("\n)");
        List commentSqls = this.columns.stream().filter(column -> StringUtils.isNotBlank((CharSequence)column.getComment())).map(column -> this.buildColumnCommentSql((Column)column, tablePath.getSchemaAndTableName("\""))).collect(Collectors.toList());
        if (!commentSqls.isEmpty()) {
            createTableSql.append(";\n");
            createTableSql.append(String.join((CharSequence)";\n", commentSqls));
            createTableSql.append(";");
        }
        return createTableSql.toString();
    }

    String buildColumnSql(Column column) {
        StringBuilder columnSql = new StringBuilder();
        columnSql.append("\"").append(column.getName()).append("\" ");
        String columnType = column.getSinkType() != null ? column.getSinkType() : (StringUtils.equals((CharSequence)"Dameng", (CharSequence)this.sourceCatalogName) && StringUtils.isNotEmpty((CharSequence)column.getSourceType()) ? column.getSourceType() : DmdbTypeConverter.INSTANCE.reconvert(column).getColumnType());
        columnSql.append(columnType);
        if (!column.isNullable()) {
            columnSql.append(" NOT NULL");
        }
        return columnSql.toString();
    }

    private String buildPrimaryKeySql(PrimaryKey primaryKey) {
        String randomSuffix = UUID.randomUUID().toString().replace("-", "").substring(0, 4);
        String columnNamesString = primaryKey.getColumnNames().stream().map(columnName -> "\"" + columnName + "\"").collect(Collectors.joining(", "));
        String primaryKeyStr = primaryKey.getPrimaryKey();
        if (primaryKeyStr.length() > 25) {
            primaryKeyStr = primaryKeyStr.substring(0, 25);
        }
        return CatalogUtils.getFieldIde("CONSTRAINT " + primaryKeyStr + "_" + randomSuffix + " PRIMARY KEY (" + columnNamesString + ")", this.fieldIde);
    }

    private String buildColumnCommentSql(Column column, String tableName) {
        StringBuilder columnCommentSql = new StringBuilder();
        columnCommentSql.append(CatalogUtils.quoteIdentifier("COMMENT ON COLUMN ", this.fieldIde)).append(CatalogUtils.quoteIdentifier(tableName, this.fieldIde)).append(".");
        columnCommentSql.append(CatalogUtils.quoteIdentifier(column.getName(), this.fieldIde, "\"")).append(CatalogUtils.quoteIdentifier(" IS '", this.fieldIde)).append(column.getComment()).append("'");
        return columnCommentSql.toString();
    }

    private String buildConstraintKeySql(ConstraintKey constraintKey) {
        String keyName;
        ConstraintKey.ConstraintType constraintType = constraintKey.getConstraintType();
        String randomSuffix = UUID.randomUUID().toString().replace("-", "").substring(0, 4);
        String constraintName = constraintKey.getConstraintName();
        if (constraintName.length() > 25) {
            constraintName = constraintName.substring(0, 25);
        }
        String indexColumns = constraintKey.getColumnNames().stream().map(constraintKeyColumn -> String.format("\"%s\"", CatalogUtils.getFieldIde(constraintKeyColumn.getColumnName(), this.fieldIde))).collect(Collectors.joining(", "));
        switch (constraintType) {
            case INDEX_KEY: {
                keyName = "KEY";
                break;
            }
            case UNIQUE_KEY: {
                keyName = "UNIQUE";
                break;
            }
            case FOREIGN_KEY: {
                keyName = "FOREIGN KEY";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported constraint type: " + constraintType);
            }
        }
        if (StringUtils.equals((CharSequence)keyName, (CharSequence)"UNIQUE")) {
            return "CONSTRAINT " + constraintName + "_" + randomSuffix + " UNIQUE (" + indexColumns + ")";
        }
        return null;
    }
}

