/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.kingbase;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.psql.PostgresTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class KingbaseTypeConverter
extends PostgresTypeConverter {
    private static final Logger log = LoggerFactory.getLogger(KingbaseTypeConverter.class);
    public static final String KB_TINYINT = "TINYINT";
    public static final String KB_MONEY = "MONEY";
    public static final String KB_BLOB = "BLOB";
    public static final String KB_CLOB = "CLOB";
    public static final String KB_BIT = "BIT";
    public static final KingbaseTypeConverter INSTANCE = new KingbaseTypeConverter();

    @Override
    public String identifier() {
        return "KingBase";
    }

    @Override
    public Column convert(BasicTypeDefine typeDefine) {
        try {
            return super.convert(typeDefine);
        }
        catch (SeaTunnelRuntimeException e) {
            String kingbaseDataType;
            PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
            switch (kingbaseDataType = typeDefine.getDataType().toUpperCase()) {
                case "TINYINT": {
                    builder.dataType((SeaTunnelDataType)BasicType.BYTE_TYPE);
                    break;
                }
                case "MONEY": {
                    builder.dataType((SeaTunnelDataType)new DecimalType(38, 18));
                    builder.columnLength(Long.valueOf(38L));
                    builder.scale(Integer.valueOf(18));
                    break;
                }
                case "BLOB": {
                    builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                    builder.columnLength(Long.valueOf(0x40000000L));
                    break;
                }
                case "CLOB": {
                    builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                    builder.columnLength(typeDefine.getLength());
                    builder.columnLength(Long.valueOf(0x40000000L));
                    break;
                }
                case "BIT": {
                    builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                    long byteLength = typeDefine.getLength() / 8L;
                    builder.columnLength(Long.valueOf(byteLength += typeDefine.getLength() % 8L > 0L ? 1L : 0L));
                    break;
                }
                default: {
                    throw CommonError.convertToSeaTunnelTypeError((String)"KingBase", (String)typeDefine.getDataType(), (String)typeDefine.getName());
                }
            }
            return builder.build();
        }
    }

    @Override
    public BasicTypeDefine reconvert(Column column) {
        try {
            return super.reconvert(column);
        }
        catch (SeaTunnelRuntimeException e) {
            throw CommonError.convertToConnectorTypeError((String)"KingBase", (String)column.getDataType().getSqlType().name(), (String)column.getName());
        }
    }
}

