/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.reader.wal;

import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.util.Clock;
import java.util.HashMap;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.FetchTask;
import org.apache.seatunnel.connectors.cdc.base.source.split.IncrementalSplit;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.offset.LsnOffset;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.reader.PostgresSourceFetchTaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresWalFetchTask
implements FetchTask<SourceSplitBase> {
    private static final Logger log = LoggerFactory.getLogger(PostgresWalFetchTask.class);
    private final IncrementalSplit split;
    private volatile boolean taskRunning = false;
    private Long lastCommitLsn;
    private PostgresStreamingChangeEventSource streamingChangeEventSource;
    private PostgresOffsetContext offsetContext;

    public PostgresWalFetchTask(IncrementalSplit split) {
        this.split = split;
    }

    @Override
    public void execute(FetchTask.Context context) throws Exception {
        PostgresSourceFetchTaskContext sourceFetchContext = (PostgresSourceFetchTaskContext)context;
        this.taskRunning = true;
        this.streamingChangeEventSource = new PostgresStreamingChangeEventSource(sourceFetchContext.getDbzConnectorConfig(), sourceFetchContext.getSnapshotter(), sourceFetchContext.getDataConnection(), sourceFetchContext.getPgEventDispatcher(), sourceFetchContext.getErrorHandler(), Clock.SYSTEM, sourceFetchContext.getDatabaseSchema(), sourceFetchContext.getTaskContext(), sourceFetchContext.getReplicationConnection());
        this.offsetContext = sourceFetchContext.getOffsetContext();
        TransactionLogSplitChangeEventSourceContext changeEventSourceContext = new TransactionLogSplitChangeEventSourceContext();
        log.info("Start streaming change event source for postgres wal split: {}", (Object)this.split.getStartupOffset().toString());
        this.streamingChangeEventSource.execute((ChangeEventSource.ChangeEventSourceContext)changeEventSourceContext, sourceFetchContext.getPartition(), this.offsetContext);
    }

    public void commitCurrentOffset(LsnOffset offset) {
        Long commitLsn;
        if (this.streamingChangeEventSource != null && offset != null && (commitLsn = Long.valueOf(offset.getLsn().asLong())) != null && (this.lastCommitLsn == null || Lsn.valueOf(commitLsn).compareTo(Lsn.valueOf(this.lastCommitLsn)) > 0)) {
            this.lastCommitLsn = commitLsn;
            HashMap<String, Long> offsets = new HashMap<String, Long>();
            offsets.put("lsn_commit", this.lastCommitLsn);
            log.info("Committing offset {} for {}", (Object)Lsn.valueOf(this.lastCommitLsn), (Object)this.split);
            this.streamingChangeEventSource.commitOffset(offsets);
        }
    }

    @Override
    public boolean isRunning() {
        return this.taskRunning;
    }

    @Override
    public void shutdown() {
        this.taskRunning = false;
    }

    @Override
    public SourceSplitBase getSplit() {
        return this.split;
    }

    private class TransactionLogSplitChangeEventSourceContext
    implements ChangeEventSource.ChangeEventSourceContext {
        private TransactionLogSplitChangeEventSourceContext() {
        }

        @Override
        public boolean isRunning() {
            return PostgresWalFetchTask.this.taskRunning;
        }
    }
}

