/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.option;

import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.connectors.cdc.debezium.DeserializeFormat;

public class SourceOptions {
    public static final String STARTUP_MODE_KEY = "startup.mode";
    public static final String STOP_MODE_KEY = "stop.mode";
    public static final Option<Integer> SNAPSHOT_SPLIT_SIZE = Options.key((String)"snapshot.split.size").intType().defaultValue((Object)8096).withDescription("The split size (number of rows) of table snapshot, captured tables are split into multiple splits when read the snapshot of table.");
    public static final Option<Integer> SNAPSHOT_FETCH_SIZE = Options.key((String)"snapshot.fetch.size").intType().defaultValue((Object)1024).withDescription("The maximum fetch size for per poll when read table snapshot.");
    public static final Option<Long> STARTUP_TIMESTAMP = Options.key((String)"startup.timestamp").longType().noDefaultValue().withDescription("Optional timestamp(mills) used in case of \"timestamp\" startup mode");
    public static final Option<String> STARTUP_SPECIFIC_OFFSET_FILE = Options.key((String)"startup.specific-offset.file").stringType().noDefaultValue().withDescription("Optional offsets used in case of \"specific\" startup mode");
    public static final Option<Long> STARTUP_SPECIFIC_OFFSET_POS = Options.key((String)"startup.specific-offset.pos").longType().noDefaultValue().withDescription("Optional offsets used in case of \"specific\" startup mode");
    public static final Option<Integer> INCREMENTAL_PARALLELISM = Options.key((String)"incremental.parallelism").intType().defaultValue((Object)1).withDescription("The number of parallel readers in the incremental phase.");
    public static final Option<Long> STOP_TIMESTAMP = Options.key((String)"stop.timestamp").longType().noDefaultValue().withDescription("Optional timestamp(mills) used in case of \"timestamp\" stop mode");
    public static final Option<String> STOP_SPECIFIC_OFFSET_FILE = Options.key((String)"stop.specific-offset.file").stringType().noDefaultValue().withDescription("Optional offsets used in case of \"specific\" stop mode");
    public static final Option<Long> STOP_SPECIFIC_OFFSET_POS = Options.key((String)"stop.specific-offset.pos").longType().noDefaultValue().withDescription("Optional offsets used in case of \"specific\" stop mode");
    public static final Option<Map<String, String>> DEBEZIUM_PROPERTIES = Options.key((String)"debezium").mapType().noDefaultValue().withDescription("Decides if the table options contains Debezium client properties that start with prefix 'debezium'.");
    public static final Option<DeserializeFormat> FORMAT = Options.key((String)"format").enumType(DeserializeFormat.class).defaultValue((Object)DeserializeFormat.DEFAULT).withDescription("Data format. The default format is seatunnel row. Optional compatible with debezium-json format.");
    public static final Option<Boolean> EXACTLY_ONCE = Options.key((String)"exactly_once").booleanType().defaultValue((Object)false).withDescription("Enable exactly once semantic.");
    public static final Option<Boolean> SCHEMA_CHANGES_ENABLED = Options.key((String)"schema-changes.enabled").booleanType().defaultValue((Object)false).withDescription("Enable send schema change events, by default is false. If set to true, the schema changes will be sent to downstream.");

    public static OptionRule.Builder getBaseRule() {
        return OptionRule.builder().optional(new Option[]{FORMAT}).optional(new Option[]{SNAPSHOT_SPLIT_SIZE, SNAPSHOT_FETCH_SIZE}).optional(new Option[]{INCREMENTAL_PARALLELISM}).optional(new Option[]{DEBEZIUM_PROPERTIES});
    }
}

