/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.offset;

import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.jdbc.JdbcConnection;
import java.util.Map;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.offset.OffsetFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.config.PostgresSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.config.PostgresSourceConfigFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.PostgresDialect;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.source.offset.LsnOffset;
import org.apache.seatunnel.connectors.seatunnel.cdc.postgres.utils.PostgresUtils;

public class LsnOffsetFactory
extends OffsetFactory {
    private final PostgresSourceConfig sourceConfig;
    private final PostgresDialect dialect;

    public LsnOffsetFactory(PostgresSourceConfigFactory configFactory, PostgresDialect dialect) {
        this.sourceConfig = configFactory.create(0);
        this.dialect = dialect;
    }

    @Override
    public Offset earliest() {
        return LsnOffset.INITIAL_OFFSET;
    }

    @Override
    public Offset neverStop() {
        return LsnOffset.NO_STOPPING_OFFSET;
    }

    @Override
    public Offset latest() {
        LsnOffset lsnOffset;
        block8: {
            JdbcConnection jdbcConnection = this.dialect.openJdbcConnection(this.sourceConfig);
            try {
                lsnOffset = PostgresUtils.currentLsn((PostgresConnection)jdbcConnection);
                if (jdbcConnection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jdbcConnection != null) {
                        try {
                            jdbcConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Read the binlog offset error", e);
                }
            }
            jdbcConnection.close();
        }
        return lsnOffset;
    }

    @Override
    public Offset specific(Map<String, String> offset) {
        return new LsnOffset(offset);
    }

    @Override
    public Offset specific(String filename, Long position) {
        throw new UnsupportedOperationException("not supported create new Offset by filename and position.");
    }

    @Override
    public Offset timestamp(long timestamp) {
        throw new UnsupportedOperationException("not supported create new Offset by timestamp.");
    }
}

