/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.raw;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.exception.CircuitBreakerOpenException;
import org.tikv.common.util.HistogramUtils;
import org.tikv.common.util.Pair;
import org.tikv.common.util.ScanOption;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.raw.RawKVClientBase;
import org.tikv.service.failsafe.CircuitBreaker;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.shade.io.prometheus.client.Counter;
import org.tikv.shade.io.prometheus.client.Histogram;

public class SmartRawKVClient
implements RawKVClientBase {
    private static final Logger logger = LoggerFactory.getLogger(SmartRawKVClient.class);
    private static final Histogram REQUEST_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("client_java_smart_raw_requests_latency")).help("client smart raw request latency.")).labelNames("type")).register();
    private static final Counter REQUEST_SUCCESS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("client_java_smart_raw_requests_success")).help("client smart raw request success.")).labelNames("type")).register();
    private static final Counter REQUEST_FAILURE = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("client_java_smart_raw_requests_failure")).help("client smart raw request failure.")).labelNames("type")).register();
    private static final Counter CIRCUIT_BREAKER_OPENED = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("client_java_smart_raw_circuit_breaker_opened")).help("client smart raw circuit breaker opened.")).labelNames("type")).register();
    private final RawKVClientBase client;
    private final CircuitBreaker circuitBreaker;

    public SmartRawKVClient(RawKVClientBase client, CircuitBreaker breaker) {
        this.client = client;
        this.circuitBreaker = breaker;
    }

    @Override
    public void put(ByteString key, ByteString value) {
        this.callWithCircuitBreaker("put", () -> this.client.put(key, value));
    }

    @Override
    public void put(ByteString key, ByteString value, long ttl) {
        this.callWithCircuitBreaker("put", () -> this.client.put(key, value, ttl));
    }

    @Override
    public Optional<ByteString> putIfAbsent(ByteString key, ByteString value) {
        return this.callWithCircuitBreaker("putIfAbsent", () -> this.client.putIfAbsent(key, value));
    }

    @Override
    public Optional<ByteString> putIfAbsent(ByteString key, ByteString value, long ttl) {
        return this.callWithCircuitBreaker("putIfAbsent", () -> this.client.putIfAbsent(key, value, ttl));
    }

    @Override
    public void compareAndSet(ByteString key, Optional<ByteString> prevValue, ByteString value) {
        this.callWithCircuitBreaker("compareAndSet", () -> this.client.compareAndSet(key, prevValue, value));
    }

    @Override
    public void compareAndSet(ByteString key, Optional<ByteString> prevValue, ByteString value, long ttl) {
        this.callWithCircuitBreaker("compareAndSet", () -> this.client.compareAndSet(key, prevValue, value, ttl));
    }

    @Override
    public void batchPut(Map<ByteString, ByteString> kvPairs) {
        this.callWithCircuitBreaker("batchPut", () -> this.client.batchPut(kvPairs));
    }

    @Override
    public void batchPut(Map<ByteString, ByteString> kvPairs, long ttl) {
        this.callWithCircuitBreaker("batchPut", () -> this.client.batchPut(kvPairs, ttl));
    }

    @Override
    public Optional<ByteString> get(ByteString key) {
        return this.callWithCircuitBreaker("get", () -> this.client.get(key));
    }

    @Override
    public List<Kvrpcpb.KvPair> batchGet(List<ByteString> keys) {
        return this.callWithCircuitBreaker("batchGet", () -> this.client.batchGet(keys));
    }

    @Override
    public void batchDelete(List<ByteString> keys) {
        this.callWithCircuitBreaker("batchDelete", () -> this.client.batchDelete(keys));
    }

    @Override
    public Optional<Long> getKeyTTL(ByteString key) {
        return this.callWithCircuitBreaker("getKeyTTL", () -> this.client.getKeyTTL(key));
    }

    @Override
    public List<List<ByteString>> batchScanKeys(List<Pair<ByteString, ByteString>> ranges, int eachLimit) {
        return this.callWithCircuitBreaker("batchScanKeys", () -> this.client.batchScanKeys(ranges, eachLimit));
    }

    @Override
    public List<List<Kvrpcpb.KvPair>> batchScan(List<ScanOption> ranges) {
        return this.callWithCircuitBreaker("batchScan", () -> this.client.batchScan(ranges));
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, ByteString endKey, int limit) {
        return this.callWithCircuitBreaker("scan", () -> this.client.scan(startKey, endKey, limit));
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, ByteString endKey, int limit, boolean keyOnly) {
        return this.callWithCircuitBreaker("scan", () -> this.client.scan(startKey, endKey, limit, keyOnly));
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, int limit) {
        return this.callWithCircuitBreaker("scan", () -> this.client.scan(startKey, limit));
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, int limit, boolean keyOnly) {
        return this.callWithCircuitBreaker("scan", () -> this.client.scan(startKey, limit, keyOnly));
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, ByteString endKey) {
        return this.callWithCircuitBreaker("scan", () -> this.client.scan(startKey, endKey));
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, ByteString endKey, boolean keyOnly) {
        return this.callWithCircuitBreaker("scan", () -> this.client.scan(startKey, endKey, keyOnly));
    }

    @Override
    public List<Kvrpcpb.KvPair> scanPrefix(ByteString prefixKey, int limit, boolean keyOnly) {
        return this.callWithCircuitBreaker("scanPrefix", () -> this.client.scanPrefix(prefixKey, limit, keyOnly));
    }

    @Override
    public List<Kvrpcpb.KvPair> scanPrefix(ByteString prefixKey) {
        return this.callWithCircuitBreaker("scanPrefix", () -> this.client.scanPrefix(prefixKey));
    }

    @Override
    public List<Kvrpcpb.KvPair> scanPrefix(ByteString prefixKey, boolean keyOnly) {
        return this.callWithCircuitBreaker("scanPrefix", () -> this.client.scanPrefix(prefixKey, keyOnly));
    }

    @Override
    public void delete(ByteString key) {
        this.callWithCircuitBreaker("delete", () -> this.client.delete(key));
    }

    @Override
    public void deleteRange(ByteString startKey, ByteString endKey) {
        this.callWithCircuitBreaker("deleteRange", () -> this.client.deleteRange(startKey, endKey));
    }

    @Override
    public void deletePrefix(ByteString key) {
        this.callWithCircuitBreaker("deletePrefix", () -> this.client.deletePrefix(key));
    }

    <T> T callWithCircuitBreaker(String funcName, Function1<T> func) {
        Histogram.Timer requestTimer = ((Histogram.Child)REQUEST_LATENCY.labels(funcName)).startTimer();
        try {
            T result = this.callWithCircuitBreaker0(funcName, func);
            ((Counter.Child)REQUEST_SUCCESS.labels(funcName)).inc();
            T t = result;
            return t;
        }
        catch (Exception e) {
            ((Counter.Child)REQUEST_FAILURE.labels(funcName)).inc();
            throw e;
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    private <T> T callWithCircuitBreaker0(String funcName, Function1<T> func) {
        if (this.circuitBreaker.allowRequest()) {
            try {
                T result = func.apply();
                this.circuitBreaker.getMetrics().recordSuccess();
                return result;
            }
            catch (Exception e) {
                this.circuitBreaker.getMetrics().recordFailure();
                throw e;
            }
        }
        if (this.circuitBreaker.attemptExecution()) {
            logger.debug("attemptExecution");
            try {
                T result = func.apply();
                this.circuitBreaker.getMetrics().recordSuccess();
                this.circuitBreaker.recordAttemptSuccess();
                logger.debug("markSuccess");
                return result;
            }
            catch (Exception e) {
                this.circuitBreaker.getMetrics().recordFailure();
                this.circuitBreaker.recordAttemptFailure();
                logger.debug("markNonSuccess");
                throw e;
            }
        }
        logger.debug("Circuit Breaker Opened");
        ((Counter.Child)CIRCUIT_BREAKER_OPENED.labels(funcName)).inc();
        throw new CircuitBreakerOpenException();
    }

    private void callWithCircuitBreaker(String funcName, Function0 func) {
        this.callWithCircuitBreaker(funcName, () -> {
            func.apply();
            return null;
        });
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    public static interface Function0 {
        public void apply();
    }

    public static interface Function1<T> {
        public T apply();
    }
}

