/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.shade.org.postgresql.core.BaseConnection;
import org.apache.seatunnel.shade.org.postgresql.core.BaseStatement;
import org.apache.seatunnel.shade.org.postgresql.core.ServerVersion;
import org.apache.seatunnel.shade.org.postgresql.core.TypeInfo;
import org.apache.seatunnel.shade.org.postgresql.util.GT;
import org.apache.seatunnel.shade.org.postgresql.util.PGobject;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLException;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLState;

public class TypeInfoCache
implements TypeInfo {
    private Map<String, Integer> _pgNameToSQLType;
    private Map<String, String> _pgNameToJavaClass;
    private Map<Integer, String> _oidToPgName;
    private Map<String, Integer> _pgNameToOid;
    private Map<String, Class<? extends PGobject>> _pgNameToPgObject;
    private Map<Integer, Integer> _pgArrayToPgType;
    private Map<Integer, Integer> _pgTableOfPgType;
    private Map<Integer, Character> _arrayOidToDelimiter;
    private BaseConnection _conn;
    private final int _unknownLength;
    private PreparedStatement _getOidStatementSimple;
    private PreparedStatement getOidStatementComplexNonArray;
    private PreparedStatement getOidStatementComplexArray;
    private PreparedStatement _getNameStatement;
    private PreparedStatement _getTypeNameByOIDStatement;
    private PreparedStatement _getArrayElementOidStatement;
    private PreparedStatement _getArrayDelimiterStatement;
    private PreparedStatement _getTypeInfoStatement;
    private PreparedStatement _getStructElementStatement;
    private Map<Integer, List<Integer>> _pgStructToPgTypes;
    private ConcurrentHashMap<Integer, List<Object[]>> compositeTypeStructMap = new ConcurrentHashMap();
    private static final Object[][] types = new Object[][]{{"int1", 5545, -6, "java.lang.Integer", 5546}, {"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"oid", 26, -5, "java.lang.Long", 1028}, {"int8", 20, -5, "java.lang.Long", 1016}, {"money", 790, 8, "java.lang.Double", 791}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"bytea", 17, -2, "[B", 1001}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"bit", 1560, -7, "java.lang.Boolean", 1561}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"smalldatetime", 9003, 93, "java.lang.Timestamp", 9005}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"json", 114, 1111, "org.apache.seatunnel.shade.org.postgresql.util.PGobject", 199}, {"point", 600, 1111, "org.apache.seatunnel.shade.org.postgresql.geometric.PGpoint", 1017}, {"blob", 88, 2004, "org.apache.seatunnel.shade.org.postgresql.util.PGobject", -1}, {"clob", 90, 2005, "org.apache.seatunnel.shade.org.postgresql.util.PGobject", -1}, {"nvarchar2", 3969, 12, "java.lang.String", 3968}, {"refcursor", 1790, 2012, "java.sql.ResultSet", 2201}};
    private static final HashMap<String, String> typeAliases = new HashMap();
    private static ConcurrentHashMap<Integer, Integer> pricisionToInteger;
    private static ConcurrentHashMap<Integer, Integer> oidToInteger;
    private final String queryStructAttributesTypeByOidSql = "select a.oid, n.nspname = ANY(current_schemas(true)), n.nspname, a.typname, attname from pg_type t join pg_class on (reltype = t.oid) join pg_attribute on (attrelid = pg_class.oid and attnum > 0) join pg_type a on (atttypid = a.oid) join pg_namespace n on (a.typnamespace = n.oid) where t.oid = ? order by pg_attribute.attnum ";

    public TypeInfoCache(BaseConnection conn, int unknownLength) {
        this._conn = conn;
        this._unknownLength = unknownLength;
        this._oidToPgName = new HashMap<Integer, String>();
        this._pgNameToOid = new HashMap<String, Integer>();
        this._pgNameToJavaClass = new HashMap<String, String>();
        this._pgNameToPgObject = new HashMap<String, Class<? extends PGobject>>();
        this._pgArrayToPgType = new HashMap<Integer, Integer>();
        this._pgTableOfPgType = new HashMap<Integer, Integer>();
        this._arrayOidToDelimiter = new HashMap<Integer, Character>();
        this._pgStructToPgTypes = new HashMap<Integer, List<Integer>>();
        this._pgNameToSQLType = Collections.synchronizedMap(new HashMap());
        for (Object[] type : types) {
            String pgTypeName = (String)type[0];
            Integer oid = (Integer)type[1];
            Integer sqlType = (Integer)type[2];
            String javaClass = (String)type[3];
            Integer arrayOid = (Integer)type[4];
            this.addCoreType(pgTypeName, oid, sqlType, javaClass, arrayOid);
        }
    }

    @Override
    public synchronized void addCoreType(String pgTypeName, Integer oid, Integer sqlType, String javaClass, Integer arrayOid) {
        this._pgNameToJavaClass.put(pgTypeName, javaClass);
        this._pgNameToOid.put(pgTypeName, oid);
        this._oidToPgName.put(oid, pgTypeName);
        this._pgArrayToPgType.put(arrayOid, oid);
        this._pgNameToSQLType.put(pgTypeName, sqlType);
        Character delim = Character.valueOf(',');
        this._arrayOidToDelimiter.put(oid, delim);
        String pgArrayTypeName = pgTypeName + "[]";
        this._pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
        this._pgNameToSQLType.put(pgArrayTypeName, 2003);
        this._pgNameToOid.put(pgArrayTypeName, arrayOid);
        pgArrayTypeName = "_" + pgTypeName;
        if (!this._pgNameToJavaClass.containsKey(pgArrayTypeName)) {
            this._pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
            this._pgNameToSQLType.put(pgArrayTypeName, 2003);
            this._pgNameToOid.put(pgArrayTypeName, arrayOid);
            this._oidToPgName.put(arrayOid, pgArrayTypeName);
        }
    }

    @Override
    public synchronized void addDataType(String type, Class<? extends PGobject> klass) throws SQLException {
        this._pgNameToPgObject.put(type, klass);
        this._pgNameToJavaClass.put(type, klass.getName());
    }

    @Override
    public Iterator<String> getPGTypeNamesWithSQLTypes() {
        return this._pgNameToSQLType.keySet().iterator();
    }

    @Override
    public int getSQLType(int oid) throws SQLException {
        return this.getSQLType(this.getPGType(oid));
    }

    @Override
    public synchronized int getSQLType(String pgTypeName) throws SQLException {
        if (pgTypeName.endsWith("[]")) {
            return 2003;
        }
        Integer i = this._pgNameToSQLType.get(pgTypeName);
        if (i != null) {
            return i;
        }
        if (this._getTypeInfoStatement == null) {
            String sql = "SELECT typinput='array_in'::regproc, typtype FROM ";
            sql = sql + "pg_catalog.";
            sql = sql + "pg_type WHERE typname = ?";
            this._getTypeInfoStatement = this._conn.prepareStatement(sql);
        }
        this._getTypeInfoStatement.setString(1, pgTypeName);
        if (!((BaseStatement)((Object)this._getTypeInfoStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getTypeInfoStatement.getResultSet();
        Integer type = null;
        if (rs.next()) {
            boolean isArray = rs.getBoolean(1);
            String typtype = rs.getString(2);
            if (isArray) {
                type = 2003;
            } else if ("c".equals(typtype)) {
                type = 2002;
            } else if ("d".equals(typtype)) {
                type = 2001;
            }
        }
        if (type == null) {
            type = 1111;
        }
        rs.close();
        this._pgNameToSQLType.put(pgTypeName, type);
        return type;
    }

    private PreparedStatement getOidStatement(String pgTypeName) throws SQLException {
        PreparedStatement oidStatementComplex;
        boolean isArray = pgTypeName.endsWith("[]");
        String[] names = this.getPgTypeSchemaName(pgTypeName, true);
        String schema = names[0];
        String typeName = names[1];
        boolean hasQuote = typeName.contains("\"");
        int dotIndex = pgTypeName.indexOf(46);
        if (schema == null && !hasQuote && !isArray) {
            if (this._getNameStatement == null) {
                String sql = "SELECT pg_type.oid, typname, typtype, typelem   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                   from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = ?  ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this._getNameStatement = this._conn.prepareStatement(sql);
            }
            String lcName = typeName.toLowerCase(Locale.ROOT);
            this._getNameStatement.setString(1, lcName);
            return this._getNameStatement;
        }
        if (isArray) {
            if (this.getOidStatementComplexArray == null) {
                String sql = this._conn.haveMinimumServerVersion(ServerVersion.v8_3) ? "SELECT t.typarray, arr.typname, arr.typtype, arr.typelem   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid  JOIN pg_catalog.pg_type arr ON arr.oid = t.typarray WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1" : "SELECT t.oid, t.typname, typtype, typelem   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typelem = (SELECT oid FROM pg_catalog.pg_type WHERE typname = ?) AND substring(t.typname, 1, 1) = '_' AND t.typlen = -1 AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.typelem DESC LIMIT 1";
                this.getOidStatementComplexArray = this._conn.prepareStatement(sql);
            }
            oidStatementComplex = this.getOidStatementComplexArray;
        } else {
            if (this.getOidStatementComplexNonArray == null) {
                String sql = "SELECT t.oid, t.typname, typtype, typelem   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1";
                this.getOidStatementComplexNonArray = this._conn.prepareStatement(sql);
            }
            oidStatementComplex = this.getOidStatementComplexNonArray;
        }
        oidStatementComplex.setString(1, typeName);
        oidStatementComplex.setString(2, schema);
        oidStatementComplex.setBoolean(3, schema == null);
        return oidStatementComplex;
    }

    private String[] getPgTypeSchemaName(String pgTypeName, boolean trimQuote) {
        String fullName;
        String[] names = new String[2];
        boolean isArray = pgTypeName.endsWith("[]");
        int dotIndex = pgTypeName.indexOf(46);
        String schema = null;
        String name = null;
        String string = fullName = isArray ? pgTypeName.substring(0, pgTypeName.length() - 2) : pgTypeName;
        if (dotIndex == -1) {
            schema = null;
            name = fullName;
        } else if (fullName.startsWith("\"")) {
            if (fullName.endsWith("\"")) {
                String[] parts = fullName.split("\"\\.\"");
                schema = parts.length == 2 ? parts[0] + "\"" : null;
                name = parts.length == 2 ? "\"" + parts[1] : parts[0];
            } else {
                int lastDotIndex = fullName.lastIndexOf(46);
                name = fullName.substring(lastDotIndex + 1);
                schema = fullName.substring(0, lastDotIndex);
            }
        } else {
            schema = fullName.substring(0, dotIndex);
            name = fullName.substring(dotIndex + 1);
        }
        if (trimQuote) {
            if (schema != null && schema.startsWith("\"") && schema.endsWith("\"")) {
                schema = schema.substring(1, schema.length() - 1);
            } else if (schema != null) {
                schema = schema.toLowerCase(Locale.ROOT);
            }
            name = name.startsWith("\"") && name.endsWith("\"") ? name.substring(1, name.length() - 1) : name.toLowerCase(Locale.ROOT);
        }
        names[0] = schema;
        names[1] = name;
        return names;
    }

    @Override
    public synchronized int getPGType(String pgTypeName) throws SQLException {
        Integer oid = this._pgNameToOid.get(pgTypeName);
        if (oid != null) {
            return oid;
        }
        PreparedStatement oidStatement = this.getOidStatement(pgTypeName);
        if (!((BaseStatement)((Object)oidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        oid = 0;
        ResultSet rs = oidStatement.getResultSet();
        if (rs.next()) {
            oid = (int)rs.getLong(1);
            String internalName = rs.getString(2);
            String tytType = rs.getString(3);
            int typElem = (int)rs.getLong(4);
            if (tytType != null && tytType.equals("b")) {
                this._pgArrayToPgType.put(oid, typElem);
            }
            if (tytType != null && tytType.equals("o")) {
                this._pgTableOfPgType.put(oid, typElem);
            }
            this._oidToPgName.put(oid, internalName);
            this._pgNameToOid.put(internalName, oid);
        }
        this._pgNameToOid.put(pgTypeName, oid);
        rs.close();
        return oid;
    }

    @Override
    public synchronized String getPGType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String pgTypeName = this._oidToPgName.get(oid);
        if (pgTypeName != null) {
            return pgTypeName;
        }
        if (this._getTypeNameByOIDStatement == null) {
            String sql = "SELECT n.nspname = ANY(current_schemas(true)), n.nspname, t.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this._getTypeNameByOIDStatement = this._conn.prepareStatement(sql);
        }
        this._getTypeNameByOIDStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getTypeNameByOIDStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getTypeNameByOIDStatement.getResultSet();
        if (rs.next()) {
            boolean onPath = rs.getBoolean(1);
            String schema = rs.getString(2);
            String name = rs.getString(3);
            if (onPath) {
                pgTypeName = name;
                this._pgNameToOid.put(schema + "." + name, oid);
            } else {
                pgTypeName = "\"" + schema + "\".\"" + name + "\"";
                if (schema.equals(schema.toLowerCase()) && schema.indexOf(46) == -1 && name.equals(name.toLowerCase()) && name.indexOf(46) == -1) {
                    this._pgNameToOid.put(schema + "." + name, oid);
                }
            }
            this._pgNameToOid.put(pgTypeName, oid);
            this._oidToPgName.put(oid, pgTypeName);
        }
        rs.close();
        return pgTypeName;
    }

    @Override
    public int getPGArrayType(String elementTypeName) throws SQLException {
        String[] newTypeNameArray;
        elementTypeName = this.getTypeForAlias(elementTypeName);
        String[] names = this.getPgTypeSchemaName(elementTypeName, false);
        String schema = null;
        if (names[0] != null) {
            schema = names[0];
            elementTypeName = names[1];
        }
        int pgType = 0;
        for (String newTypeName : newTypeNameArray = new String[]{elementTypeName + "[]", elementTypeName}) {
            Integer elementId;
            if (schema != null && !schema.equals("")) {
                newTypeName = schema + "." + newTypeName;
            }
            if ((elementId = this._pgTableOfPgType.get(pgType = this.getPGType(newTypeName))) != null && elementId > 0) {
                return elementId;
            }
            elementId = this._pgArrayToPgType.get(pgType);
            if (elementId == null || pgType == 0) continue;
            return pgType;
        }
        return pgType;
    }

    protected synchronized int convertArrayToBaseOid(int oid) {
        Integer i = this._pgArrayToPgType.get(oid);
        if (i == null) {
            return oid;
        }
        return i;
    }

    @Override
    public synchronized char getArrayDelimiter(int oid) throws SQLException {
        if (oid == 0) {
            return ',';
        }
        Character delim = this._arrayOidToDelimiter.get(oid);
        if (delim != null) {
            return delim.charValue();
        }
        if (this._getArrayDelimiterStatement == null) {
            String sql = "SELECT e.typdelim FROM pg_catalog.pg_type t, pg_catalog.pg_type e WHERE t.oid = ? and t.typelem = e.oid";
            this._getArrayDelimiterStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayDelimiterStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayDelimiterStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayDelimiterStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        String s2 = rs.getString(1);
        delim = Character.valueOf(s2.charAt(0));
        this._arrayOidToDelimiter.put(oid, delim);
        rs.close();
        return delim.charValue();
    }

    @Override
    public synchronized int getPGArrayElement(int oid) throws SQLException {
        if (oid == 0) {
            return 0;
        }
        Integer pgType = this._pgArrayToPgType.get(oid);
        if (pgType != null) {
            return pgType;
        }
        if (this._getArrayElementOidStatement == null) {
            String sql = "SELECT e.oid, n.nspname = ANY(current_schemas(true)), n.nspname, e.typname, t.typtype as Ptyptype, e.typtype as Ctyptype FROM pg_catalog.pg_type t JOIN pg_catalog.pg_type e ON t.typelem = e.oid JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this._getArrayElementOidStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayElementOidStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayElementOidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayElementOidStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        pgType = (int)rs.getLong(1);
        boolean onPath = rs.getBoolean(2);
        String schema = rs.getString(3);
        String name = rs.getString(4);
        String pTytType = rs.getString(5);
        String cTytType = rs.getString(6);
        if (pTytType.equals("o") && cTytType.equals("b")) {
            return this.getPGArrayElement(pgType);
        }
        this._pgArrayToPgType.put(oid, pgType);
        this._pgNameToOid.put(schema + "." + name, pgType);
        String fullName = "\"" + schema + "\".\"" + name + "\"";
        this._pgNameToOid.put(fullName, pgType);
        if (onPath && name.equals(name.toLowerCase())) {
            this._oidToPgName.put(pgType, name);
            this._pgNameToOid.put(name, pgType);
        } else {
            this._oidToPgName.put(pgType, fullName);
        }
        rs.close();
        return pgType;
    }

    @Override
    public synchronized Class<? extends PGobject> getPGobject(String type) {
        return this._pgNameToPgObject.get(type);
    }

    @Override
    public synchronized String getJavaClass(int oid) throws SQLException {
        String pgTypeName = this.getPGType(oid);
        String result = this._pgNameToJavaClass.get(pgTypeName);
        if (result != null) {
            return result;
        }
        if (this.getSQLType(pgTypeName) == 2003) {
            result = "java.sql.Array";
            this._pgNameToJavaClass.put(pgTypeName, result);
        }
        return result;
    }

    @Override
    public String getTypeForAlias(String alias) {
        String type = typeAliases.get(alias);
        if (type != null) {
            return type;
        }
        if (alias.indexOf(34) == -1 && (type = typeAliases.get(alias.toLowerCase())) != null) {
            return type;
        }
        return alias;
    }

    @Override
    public int getPrecision(int oid, int typmod) {
        if (pricisionToInteger.containsKey(oid = this.convertArrayToBaseOid(oid))) {
            return pricisionToInteger.get(oid);
        }
        switch (oid) {
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return (typmod - 4 & 0xFFFF0000) >> 16;
            }
            case 1042: 
            case 1043: 
            case 3969: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 9003: {
                return this.getDisplaySize(oid, typmod);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod;
            }
        }
        return this._unknownLength;
    }

    @Override
    public int getScale(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
            case 1186: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod & 0xFFFF;
            }
        }
        return 0;
    }

    @Override
    public boolean isCaseSensitive(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 700: 
            case 701: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 1560: 
            case 1562: 
            case 1700: 
            case 5545: 
            case 9003: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: {
                return true;
            }
        }
        return false;
    }

    private int getValueOfTime(int oid, int typmod) {
        int secondSize;
        switch (typmod) {
            case -1: {
                secondSize = 7;
                break;
            }
            case 0: {
                secondSize = 0;
                break;
            }
            case 1: {
                secondSize = 3;
                break;
            }
            default: {
                secondSize = typmod + 1;
            }
        }
        switch (oid) {
            case 1083: {
                return 8 + secondSize;
            }
            case 1266: {
                return 8 + secondSize + 6;
            }
            case 9003: {
                return 22;
            }
            case 1114: {
                return 22 + secondSize;
            }
        }
        return 22 + secondSize + 6;
    }

    @Override
    public int getDisplaySize(int oid, int typmod) {
        if (oidToInteger.containsKey(oid = this.convertArrayToBaseOid(oid))) {
            return oidToInteger.get(oid);
        }
        switch (oid) {
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: 
            case 9003: {
                return this.getValueOfTime(oid, typmod);
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod;
            }
            case 17: 
            case 25: {
                return this._unknownLength;
            }
        }
        return this._unknownLength;
    }

    @Override
    public int getMaximumPrecision(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 1700: {
                return 1000;
            }
            case 1083: 
            case 1266: {
                return 6;
            }
            case 1114: 
            case 1184: 
            case 1186: 
            case 9003: {
                return 6;
            }
            case 1042: 
            case 1043: {
                return 0xA00000;
            }
            case 1560: 
            case 1562: {
                return 0x5000000;
            }
        }
        return 0;
    }

    @Override
    public boolean requiresQuoting(int oid) throws SQLException {
        int sqlType = this.getSQLType(oid);
        return this.requiresQuotingSqlType(sqlType);
    }

    @Override
    public boolean requiresQuotingSqlType(int sqlType) throws SQLException {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<Integer> getStructAttributesOid(int oid) throws SQLException {
        List<Object[]> struct = this.getCompositeTypeStruct(oid);
        if (struct == null) {
            return null;
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (Object[] objects : struct) {
            res.add((Integer)objects[1]);
        }
        return res;
    }

    @Override
    public Object[] getStructAttributesName(int oid) throws SQLException {
        List<Object[]> struct = this.getCompositeTypeStruct(oid);
        if (struct == null) {
            return null;
        }
        Object[] res = new Object[struct.size()];
        for (int i = 0; i < struct.size(); ++i) {
            res[i] = struct.get(i)[0];
        }
        return res;
    }

    private List<Object[]> getCompositeTypeStruct(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        List<Object[]> list = this.compositeTypeStructMap.get(oid);
        if (list != null) {
            return list;
        }
        if (this._getStructElementStatement == null) {
            this._getStructElementStatement = this._conn.prepareStatement("select a.oid, n.nspname = ANY(current_schemas(true)), n.nspname, a.typname, attname from pg_type t join pg_class on (reltype = t.oid) join pg_attribute on (attrelid = pg_class.oid and attnum > 0) join pg_type a on (atttypid = a.oid) join pg_namespace n on (a.typnamespace = n.oid) where t.oid = ? order by pg_attribute.attnum ");
        }
        this._getStructElementStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getStructElementStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getStructElementStatement.getResultSet();
        ArrayList<Object[]> compositeType = new ArrayList<Object[]>();
        while (rs.next()) {
            int attrOid = rs.getInt(1);
            boolean onPath = rs.getBoolean(2);
            String schema = rs.getString(3);
            String typName = rs.getString(4);
            String attrName = rs.getString(5);
            this._pgNameToOid.put(schema + "." + typName, attrOid);
            String fullName = "\"" + schema + "\".\"" + typName + "\"";
            this._pgNameToOid.put(fullName, attrOid);
            if (onPath && typName.equals(typName.toLowerCase())) {
                this._oidToPgName.put(attrOid, typName);
                this._pgNameToOid.put(typName, attrOid);
            } else {
                this._oidToPgName.put(attrOid, fullName);
            }
            compositeType.add(new Object[]{attrName, attrOid});
        }
        rs.close();
        this.compositeTypeStructMap.put(oid, compositeType);
        return compositeType;
    }

    static {
        typeAliases.put("tinyint", "int1");
        typeAliases.put("smallint", "int2");
        typeAliases.put("integer", "int4");
        typeAliases.put("int", "int4");
        typeAliases.put("bigint", "int8");
        typeAliases.put("float", "float8");
        typeAliases.put("boolean", "bool");
        typeAliases.put("decimal", "numeric");
        pricisionToInteger = new ConcurrentHashMap();
        pricisionToInteger.put(5545, 3);
        pricisionToInteger.put(21, 5);
        pricisionToInteger.put(26, 10);
        pricisionToInteger.put(23, 10);
        pricisionToInteger.put(20, 19);
        pricisionToInteger.put(700, 8);
        pricisionToInteger.put(701, 17);
        pricisionToInteger.put(18, 1);
        pricisionToInteger.put(16, 1);
        oidToInteger = new ConcurrentHashMap();
        oidToInteger.put(5545, 3);
        oidToInteger.put(21, 6);
        oidToInteger.put(23, 11);
        oidToInteger.put(26, 10);
        oidToInteger.put(20, 20);
        oidToInteger.put(700, 15);
        oidToInteger.put(701, 25);
        oidToInteger.put(18, 1);
        oidToInteger.put(16, 1);
        oidToInteger.put(1082, 13);
        oidToInteger.put(1186, 49);
    }
}

