/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.postgresql.clusterhealthy;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.seatunnel.shade.org.postgresql.PGProperty;
import org.apache.seatunnel.shade.org.postgresql.clusterhealthy.ClusterHeartBeat;
import org.apache.seatunnel.shade.org.postgresql.clusterhealthy.ClusterHeartBeatFailureMaster;
import org.apache.seatunnel.shade.org.postgresql.log.Log;
import org.apache.seatunnel.shade.org.postgresql.log.Logger;
import org.apache.seatunnel.shade.org.postgresql.util.HostSpec;
import org.apache.seatunnel.shade.org.postgresql.util.PSQLException;

public class ClusterNodeCache {
    private static volatile boolean status;
    private static final Object STATUS_LOCK;
    private static Log LOGGER;
    private static ExecutorService executorService;
    private static final ClusterHeartBeat CLUSTER_HEART_BEAT;

    public static boolean isOpen() {
        return status;
    }

    public static void checkReplacement(HostSpec[] hostSpecs) {
        if (hostSpecs == null) {
            return;
        }
        ClusterHeartBeatFailureMaster failureMaster = ClusterHeartBeatFailureMaster.getInstance();
        Map<HostSpec, HostSpec> failureMap = failureMaster.getFailureMaster();
        for (int i = 0; i < hostSpecs.length; ++i) {
            while (failureMap.containsKey(hostSpecs[i])) {
                if (hostSpecs[i] == failureMap.get(hostSpecs[i])) {
                    failureMaster.remove(hostSpecs[i]);
                    return;
                }
                hostSpecs[i] = failureMap.get(hostSpecs[i]);
            }
        }
    }

    public static void checkHostSpecs(HostSpec[] hostSpecs) throws PSQLException {
        Set set = Arrays.stream(hostSpecs).collect(Collectors.toSet());
        if (set.size() > 1) {
            ClusterNodeCache.checkReplacement(hostSpecs);
        }
    }

    public static void pushHostSpecs(HostSpec master, HostSpec[] hostSpecs, Properties properties) {
        Set set = Arrays.stream(hostSpecs).collect(Collectors.toSet());
        String period = PGProperty.HEARTBEAT_PERIOD.get(properties);
        if (!ClusterNodeCache.isNumeric(period)) {
            LOGGER.debug("Invalid heartbeatPeriod value: " + period);
            return;
        }
        long timePeriod = Long.parseLong(period);
        if (timePeriod <= 0L) {
            LOGGER.debug("Invalid heartbeatPeriod value: " + period);
            return;
        }
        if (set.size() > 1) {
            CLUSTER_HEART_BEAT.addNodeRelationship(master, hostSpecs, properties);
            ClusterNodeCache.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start() {
        if (status) {
            LOGGER.info("heartbeat thread ----> started");
            return;
        }
        Object object = STATUS_LOCK;
        synchronized (object) {
            if (status) {
                LOGGER.info("heartbeat thread ----> started");
                return;
            }
            status = true;
        }
        if (executorService == null) {
            executorService = Executors.newSingleThreadExecutor();
        }
        executorService.execute(CLUSTER_HEART_BEAT::masterNodeProbe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Object object = STATUS_LOCK;
        synchronized (object) {
            status = false;
            CLUSTER_HEART_BEAT.clear();
            CLUSTER_HEART_BEAT.initPeriodTime();
            executorService.shutdown();
            executorService = Executors.newSingleThreadExecutor();
        }
    }

    public static boolean isNumeric(CharSequence cs) {
        if (cs.length() == 0) {
            return false;
        }
        int size = cs.length();
        for (int i = 0; i < size; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDetection() {
        Object object = STATUS_LOCK;
        synchronized (object) {
            CLUSTER_HEART_BEAT.updateDetection();
        }
    }

    static {
        STATUS_LOCK = new Object();
        LOGGER = Logger.getLogger(ClusterNodeCache.class.getName());
        executorService = null;
        CLUSTER_HEART_BEAT = new ClusterHeartBeat();
    }
}

