/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.utils.CatalogUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleTypeConverter;

public class OracleCreateTableSqlBuilder {
    private List<Column> columns;
    private PrimaryKey primaryKey;
    private String sourceCatalogName;
    private String fieldIde;
    private boolean createIndex;

    public OracleCreateTableSqlBuilder(CatalogTable catalogTable, boolean createIndex) {
        this.columns = catalogTable.getTableSchema().getColumns();
        this.primaryKey = catalogTable.getTableSchema().getPrimaryKey();
        this.sourceCatalogName = catalogTable.getCatalogName();
        this.fieldIde = (String)catalogTable.getOptions().get("fieldIde");
        this.createIndex = createIndex;
    }

    public List<String> build(TablePath tablePath) {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder createTableSql = new StringBuilder();
        createTableSql.append("CREATE TABLE ").append(tablePath.getSchemaAndTableName("\"")).append(" (\n");
        List columnSqls = this.columns.stream().map(column -> CatalogUtils.getFieldIde(this.buildColumnSql((Column)column), this.fieldIde)).collect(Collectors.toList());
        if (this.createIndex && this.primaryKey != null && this.primaryKey.getColumnNames() != null && this.primaryKey.getColumnNames().size() > 0) {
            columnSqls.add(this.buildPrimaryKeySql(this.primaryKey));
        }
        createTableSql.append(String.join((CharSequence)",\n", columnSqls));
        createTableSql.append("\n)");
        sqls.add(createTableSql.toString());
        List commentSqls = this.columns.stream().filter(column -> StringUtils.isNotBlank(column.getComment())).map(column -> this.buildColumnCommentSql((Column)column, tablePath.getSchemaAndTableName("\""))).collect(Collectors.toList());
        sqls.addAll(commentSqls);
        return sqls;
    }

    private String buildColumnSql(Column column) {
        StringBuilder columnSql = new StringBuilder();
        columnSql.append("\"").append(column.getName()).append("\" ");
        String columnType = StringUtils.equalsIgnoreCase("Oracle", this.sourceCatalogName) ? column.getSourceType() : OracleTypeConverter.INSTANCE.reconvert(column).getColumnType();
        columnSql.append(columnType);
        if (!column.isNullable()) {
            columnSql.append(" NOT NULL");
        }
        return columnSql.toString();
    }

    private String buildPrimaryKeySql(PrimaryKey primaryKey) {
        String randomSuffix = UUID.randomUUID().toString().replace("-", "").substring(0, 4);
        String columnNamesString = primaryKey.getColumnNames().stream().map(columnName -> "\"" + columnName + "\"").collect(Collectors.joining(", "));
        String primaryKeyStr = primaryKey.getPrimaryKey();
        if (primaryKeyStr.length() > 25) {
            primaryKeyStr = primaryKeyStr.substring(0, 25);
        }
        return CatalogUtils.getFieldIde("CONSTRAINT " + primaryKeyStr + "_" + randomSuffix + " PRIMARY KEY (" + columnNamesString + ")", this.fieldIde);
    }

    private String buildColumnCommentSql(Column column, String tableName) {
        StringBuilder columnCommentSql = new StringBuilder();
        columnCommentSql.append(CatalogUtils.quoteIdentifier("COMMENT ON COLUMN ", this.fieldIde)).append(tableName).append(".");
        columnCommentSql.append(CatalogUtils.quoteIdentifier(column.getName(), this.fieldIde, "\"")).append(CatalogUtils.quoteIdentifier(" IS '", this.fieldIde)).append(column.getComment().replace("'", "''")).append("'");
        return columnCommentSql.toString();
    }
}

