/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.offset;

import java.util.Map;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.offset.OffsetFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.exception.MongodbConnectorException;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.offset.ChangeStreamOffset;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils.MongodbRecordUtils;

public class ChangeStreamOffsetFactory
extends OffsetFactory {
    public Offset earliest() {
        return new ChangeStreamOffset(MongodbRecordUtils.currentBsonTimestamp());
    }

    public Offset neverStop() {
        return ChangeStreamOffset.NO_STOPPING_OFFSET;
    }

    public Offset latest() {
        return new ChangeStreamOffset(MongodbRecordUtils.currentBsonTimestamp());
    }

    public Offset specific(Map<String, String> offset) {
        return new ChangeStreamOffset(offset);
    }

    public Offset specific(String filename, Long position) {
        throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "not supported create new Offset by filename and position.");
    }

    public Offset timestamp(long timestamp) {
        return new ChangeStreamOffset(MongodbRecordUtils.bsonTimestampFromEpochMillis(timestamp));
    }
}

