/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util.jmx.internal;

import com.mongodb.kafka.connect.util.jmx.internal.AdditiveMetric;
import com.mongodb.kafka.connect.util.jmx.internal.LatestMetric;
import com.mongodb.kafka.connect.util.jmx.internal.MBeanServerUtils;
import com.mongodb.kafka.connect.util.jmx.internal.Metric;
import com.mongodb.kafka.connect.util.jmx.internal.MetricValue;
import com.mongodb.kafka.connect.util.jmx.internal.TotalMetric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;

public class MongoMBean
implements DynamicMBean {
    protected static final long[] MS_LIMITS = new long[]{1L, 10L, 100L, 1000L, 10000L};
    private String mBeanName;
    private final List<Metric> metrics = new ArrayList<Metric>();
    private final Map<String, MetricValue> metricsMap = new HashMap<String, MetricValue>();

    protected MongoMBean(String mBeanName) {
        this.mBeanName = mBeanName;
    }

    public String getName() {
        return this.mBeanName;
    }

    protected TotalMetric registerTotal(String name) {
        return this.register(new TotalMetric(name));
    }

    protected LatestMetric registerLatest(String name) {
        return this.register(new LatestMetric(name));
    }

    protected AdditiveMetric registerMs(String name) {
        return this.register(new AdditiveMetric(name, "ms", MS_LIMITS));
    }

    protected <T extends Metric> T register(T m3) {
        m3.emit(value -> {
            if (this.metricsMap.containsKey(value.getName())) {
                throw new IllegalArgumentException(value.getName() + " already registered");
            }
        });
        this.metrics.add(m3);
        m3.emit(value -> this.metricsMap.put(value.getName(), (MetricValue)value));
        return m3;
    }

    public void emit(Consumer<MetricValue> consumer) {
        this.metrics.forEach(x -> x.emit(consumer));
    }

    public String toJSON() {
        StringBuilder sb = new StringBuilder("{");
        this.emit(v -> {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"").append(v.getName()).append("\": ");
            sb.append(v.get());
        });
        sb.append("}");
        return sb.toString();
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException {
        if (this.metricsMap.containsKey(name)) {
            return new Attribute(name, this.metricsMap.get(name).get());
        }
        throw new AttributeNotFoundException("getAttribute failed: value not found for: " + name);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String name : attributes) {
            if (!this.metricsMap.containsKey(name)) continue;
            list.add(new Attribute(name, this.metricsMap.get(name).get()));
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList attrs = new ArrayList();
        for (Metric metric : this.metrics) {
            metric.emit(value -> attrs.add(new MBeanAttributeInfo(value.getName(), Long.TYPE.getName(), this.getDescription(value.getName()), true, false, false)));
        }
        return new MBeanInfo(this.getClass().getName(), null, attrs.toArray(new MBeanAttributeInfo[0]), null, null, null);
    }

    protected String getDescription(String name) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Attribute attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException();
    }

    public void register() {
        this.mBeanName = MBeanServerUtils.registerMBean(this, this.mBeanName);
    }

    public void unregister() {
        MBeanServerUtils.unregisterMBean(this.mBeanName);
    }
}

