/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import com.mongodb.connection.SslSettings;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.types.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslConfigs {
    static final Logger LOGGER = LoggerFactory.getLogger(SslConfigs.class);
    private static final String EMPTY_STRING = "";
    public static final String CONNECTION_SSL_TRUSTSTORE_CONFIG = "connection.ssl.truststore";
    private static final String CONNECTION_SSL_TRUSTSTORE_DOC = "A trust store certificate location to be used for SSL enabled connections";
    public static final String CONNECTION_SSL_TRUSTSTORE_DEFAULT = "";
    private static final String CONNECTION_SSL_TRUSTSTORE_DISPLAY = "SSL TrustStore";
    public static final String CONNECTION_SSL_TRUSTSTORE_PASSWORD_CONFIG = "connection.ssl.truststorePassword";
    private static final String CONNECTION_SSL_TRUSTSTORE_PASSWORD_DOC = "A trust store password to be used for SSL enabled connections";
    public static final String CONNECTION_SSL_TRUSTSTORE_PASSWORD_DEFAULT = "";
    private static final String CONNECTION_SSL_TRUSTSTORE_PASSWORD_DISPLAY = "SSL TrustStore Password";
    public static final String CONNECTION_SSL_KEYSTORE_CONFIG = "connection.ssl.keystore";
    private static final String CONNECTION_SSL_KEYSTORE_DOC = "A key store certificate location to be used for SSL enabled connections";
    public static final String CONNECTION_SSL_KEYSTORE_DEFAULT = "";
    private static final String CONNECTION_SSL_KEYSTORE_DISPLAY = "SSL KeyStore";
    public static final String CONNECTION_SSL_KEYSTORE_PASSWORD_CONFIG = "connection.ssl.keystorePassword";
    private static final String CONNECTION_SSL_KEYSTORE_PASSWORD_DOC = "A key store password to be used for SSL enabled connections";
    public static final String CONNECTION_SSL_KEYSTORE_PASSWORD_DEFAULT = "";
    private static final String CONNECTION_SSL_KEYSTORE_PASSWORD_DISPLAY = "SSL KeyStore Password";

    public static ConfigDef addSslConfigDef(ConfigDef configDef) {
        String group = "SSL";
        int orderInGroup = 0;
        configDef.define(CONNECTION_SSL_TRUSTSTORE_CONFIG, ConfigDef.Type.STRING, "", ConfigDef.Importance.MEDIUM, CONNECTION_SSL_TRUSTSTORE_DOC, group, ++orderInGroup, ConfigDef.Width.LONG, CONNECTION_SSL_TRUSTSTORE_DISPLAY).define(CONNECTION_SSL_TRUSTSTORE_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, "", ConfigDef.Importance.MEDIUM, CONNECTION_SSL_TRUSTSTORE_PASSWORD_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, CONNECTION_SSL_TRUSTSTORE_PASSWORD_DISPLAY).define(CONNECTION_SSL_KEYSTORE_CONFIG, ConfigDef.Type.STRING, "", ConfigDef.Importance.MEDIUM, CONNECTION_SSL_KEYSTORE_DOC, group, ++orderInGroup, ConfigDef.Width.LONG, CONNECTION_SSL_KEYSTORE_DISPLAY).define(CONNECTION_SSL_KEYSTORE_PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, "", ConfigDef.Importance.MEDIUM, CONNECTION_SSL_KEYSTORE_PASSWORD_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, CONNECTION_SSL_KEYSTORE_PASSWORD_DISPLAY);
        return configDef;
    }

    public static void setupSsl(SslSettings.Builder sslSettingsBuilder, AbstractConfig config) {
        try {
            TrustManager[] trustManagers = null;
            KeyManager[] keyManagers = null;
            String storePath = config.getString(CONNECTION_SSL_TRUSTSTORE_CONFIG);
            Password storePassword = config.getPassword(CONNECTION_SSL_TRUSTSTORE_PASSWORD_CONFIG);
            String string = storePath = storePath != null ? storePath.trim() : null;
            if (storePath != null && !storePath.isEmpty()) {
                try (InputStream trustStoreInputStream = Files.newInputStream(Paths.get(storePath, new String[0]), new OpenOption[0]);){
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    trustStore.load(trustStoreInputStream, storePassword.value().trim().toCharArray());
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(trustStore);
                    trustManagers = trustManagerFactory.getTrustManagers();
                }
            }
            storePath = config.getString(CONNECTION_SSL_KEYSTORE_CONFIG);
            storePassword = config.getPassword(CONNECTION_SSL_KEYSTORE_PASSWORD_CONFIG);
            String string2 = storePath = storePath != null ? storePath.trim() : null;
            if (storePath != null && !storePath.isEmpty()) {
                try (InputStream keyStoreInputStream = Files.newInputStream(Paths.get(storePath, new String[0]), new OpenOption[0]);){
                    char[] pwd = storePassword.value().trim().toCharArray();
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore.load(keyStoreInputStream, pwd);
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(keyStore, pwd);
                    keyManagers = keyManagerFactory.getKeyManagers();
                }
            }
            if (trustManagers == null && keyManagers == null) {
                return;
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            sslSettingsBuilder.context(sslContext);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize SSLContext. SSL configuration will be ignored.", (Throwable)e);
        }
    }

    private SslConfigs() {
    }
}

