/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.writemodel.strategy;

import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.Configurable;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.id.strategy.IdStrategy;
import com.mongodb.kafka.connect.sink.processor.id.strategy.PartialKeyStrategy;
import com.mongodb.kafka.connect.sink.processor.id.strategy.PartialValueStrategy;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelHelper;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelStrategy;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class DeleteOneBusinessKeyStrategy
implements WriteModelStrategy,
Configurable {
    private boolean isPartialId = false;

    @Override
    public WriteModel<BsonDocument> createWriteModel(SinkDocument document) {
        BsonDocument vd = document.getValueDoc().orElseThrow(() -> new DataException("Could not build the WriteModel,the value document was missing unexpectedly"));
        BsonValue idValue = vd.get("_id");
        if (idValue == null || !idValue.isDocument()) {
            throw new DataException("Could not build the WriteModel, the value document does not contain an _id field of type BsonDocument which holds the business key fields.");
        }
        BsonDocument businessKey = idValue.asDocument();
        vd.remove("_id");
        if (this.isPartialId) {
            businessKey = WriteModelHelper.flattenKeys(businessKey);
        }
        return new DeleteOneModel<BsonDocument>(businessKey);
    }

    @Override
    public void configure(MongoSinkTopicConfig configuration) {
        IdStrategy idStrategy = configuration.getIdStrategy();
        this.isPartialId = idStrategy instanceof PartialKeyStrategy || idStrategy instanceof PartialValueStrategy;
    }
}

