/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.field.projection;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.PostProcessor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;

public abstract class FieldProjector
extends PostProcessor {
    private static final String FIELD_LIST_SPLIT_EXPR = "\\s*,\\s*";
    static final String SINGLE_WILDCARD = "*";
    static final String DOUBLE_WILDCARD = "**";
    static final String SUB_FIELD_DOT_SEPARATOR = ".";
    private final Set<String> fields;
    private final SinkDocumentField sinkDocumentField;

    public FieldProjector(MongoSinkTopicConfig config, Set<String> fields, SinkDocumentField sinkDocumentField) {
        super(config);
        this.fields = fields;
        this.sinkDocumentField = sinkDocumentField;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    @Override
    public void process(SinkDocument doc, SinkRecord orig) {
        this.getDocumentToProcess(doc).ifPresent(this::projectDocument);
    }

    private Optional<BsonDocument> getDocumentToProcess(SinkDocument sinkDocument) {
        return this.sinkDocumentField == SinkDocumentField.KEY ? sinkDocument.getKeyDoc() : sinkDocument.getValueDoc();
    }

    protected abstract void projectDocument(BsonDocument var1);

    public static Set<String> buildProjectionList(MongoSinkTopicConfig.FieldProjectionType fieldProjectionType, String fieldList) {
        HashSet<String> projectionList;
        switch (fieldProjectionType) {
            case BLOCKLIST: 
            case BLACKLIST: {
                projectionList = new HashSet<String>(FieldProjector.toList(fieldList));
                break;
            }
            case ALLOWLIST: 
            case WHITELIST: {
                projectionList = new HashSet<String>();
                List<String> fields = FieldProjector.toList(fieldList);
                Iterator<String> iterator = fields.iterator();
                while (iterator.hasNext()) {
                    String f;
                    String entry = f = iterator.next();
                    projectionList.add(entry);
                    while (entry.contains(SUB_FIELD_DOT_SEPARATOR)) {
                        if ((entry = entry.substring(0, entry.lastIndexOf(SUB_FIELD_DOT_SEPARATOR))).isEmpty()) continue;
                        projectionList.add(entry);
                    }
                }
                break;
            }
            default: {
                projectionList = new HashSet();
            }
        }
        return projectionList;
    }

    private static List<String> toList(String value) {
        return Arrays.stream(value.trim().split(FIELD_LIST_SPLIT_EXPR)).filter(s2 -> !s2.isEmpty()).collect(Collectors.toList());
    }

    public static enum SinkDocumentField {
        KEY,
        VALUE;

    }
}

