/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink;

import com.mongodb.MongoNamespace;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.MongoSinkConfig;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkConverter;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelStrategyHelper;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoProcessedSinkRecordData {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoProcessedSinkRecordData.class);
    private static final SinkConverter SINK_CONVERTER = new SinkConverter();
    private final MongoSinkTopicConfig config;
    private final MongoNamespace namespace;
    private final SinkRecord sinkRecord;
    private final SinkDocument sinkDocument;
    private final WriteModel<BsonDocument> writeModel;
    private Exception exception;

    MongoProcessedSinkRecordData(SinkRecord sinkRecord, MongoSinkConfig sinkConfig) {
        this.sinkRecord = sinkRecord;
        this.config = sinkConfig.getMongoSinkTopicConfig(sinkRecord.topic());
        this.sinkDocument = SINK_CONVERTER.convert(sinkRecord);
        this.namespace = this.createNamespace();
        this.writeModel = this.createWriteModel();
    }

    public MongoSinkTopicConfig getConfig() {
        return this.config;
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public SinkRecord getSinkRecord() {
        return this.sinkRecord;
    }

    public WriteModel<BsonDocument> getWriteModel() {
        return this.writeModel;
    }

    public Exception getException() {
        return this.exception;
    }

    private MongoNamespace createNamespace() {
        return this.tryProcess(() -> Optional.of(this.config.getNamespaceMapper().getNamespace(this.sinkRecord, this.sinkDocument))).orElse(null);
    }

    private WriteModel<BsonDocument> createWriteModel() {
        return this.config.getCdcHandler().isPresent() ? this.buildWriteModelCDC() : this.buildWriteModel();
    }

    private WriteModel<BsonDocument> buildWriteModel() {
        return this.tryProcess(() -> {
            this.config.getPostProcessors().getPostProcessorList().forEach(pp -> pp.process(this.sinkDocument, this.sinkRecord));
            return Optional.ofNullable(WriteModelStrategyHelper.createWriteModel(this.config, this.sinkDocument));
        }).orElse(null);
    }

    private WriteModel<BsonDocument> buildWriteModelCDC() {
        return this.tryProcess(() -> this.config.getCdcHandler().flatMap(cdcHandler -> cdcHandler.handle(this.sinkDocument))).orElse(null);
    }

    private <T> Optional<T> tryProcess(Supplier<Optional<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            this.exception = e;
            if (this.config.logErrors()) {
                LOGGER.error("Unable to process record {}", (Object)this.sinkRecord, (Object)e);
            }
            if (!this.config.tolerateErrors()) {
                throw e;
            }
            return Optional.empty();
        }
    }
}

