/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.mongodb.AwsCredential;
import com.mongodb.MongoInternalException;
import com.mongodb.lang.NonNull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bson.BsonDocument;

public final class AwsCredentialHelper {
    public static AwsCredential obtainFromEnvironment() {
        if (System.getenv("AWS_ACCESS_KEY_ID") != null) {
            return AwsCredentialHelper.obtainFromEnvironmentVariables();
        }
        return AwsCredentialHelper.obtainFromEc2OrEcsResponse();
    }

    private static AwsCredential obtainFromEnvironmentVariables() {
        return new AwsCredential(System.getenv("AWS_ACCESS_KEY_ID"), System.getenv("AWS_SECRET_ACCESS_KEY"), System.getenv("AWS_SESSION_TOKEN"));
    }

    private static AwsCredential obtainFromEc2OrEcsResponse() {
        String path = System.getenv("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI");
        BsonDocument ec2OrEcsResponse = path == null ? BsonDocument.parse(AwsCredentialHelper.getEc2Response()) : BsonDocument.parse(AwsCredentialHelper.getEcsResponse(path));
        return new AwsCredential(ec2OrEcsResponse.getString("AccessKeyId").getValue(), ec2OrEcsResponse.getString("SecretAccessKey").getValue(), ec2OrEcsResponse.getString("Token").getValue());
    }

    private static String getEcsResponse(String path) {
        return AwsCredentialHelper.getHttpContents("GET", "http://169.254.170.2" + path, null);
    }

    private static String getEc2Response() {
        String endpoint = "http://169.254.169.254";
        String path = "/latest/meta-data/iam/security-credentials/";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("X-aws-ec2-metadata-token-ttl-seconds", "30");
        String token = AwsCredentialHelper.getHttpContents("PUT", "http://169.254.169.254/latest/api/token", header);
        header.clear();
        header.put("X-aws-ec2-metadata-token", token);
        String role = AwsCredentialHelper.getHttpContents("GET", "http://169.254.169.254/latest/meta-data/iam/security-credentials/", header);
        return AwsCredentialHelper.getHttpContents("GET", "http://169.254.169.254/latest/meta-data/iam/security-credentials/" + role, header);
    }

    @NonNull
    private static String getHttpContents(String method, String endpoint, Map<String, String> headers) {
        StringBuilder content = new StringBuilder();
        HttpURLConnection conn = null;
        try {
            int status;
            conn = (HttpURLConnection)new URL(endpoint).openConnection();
            conn.setRequestMethod(method);
            conn.setReadTimeout(10000);
            if (headers != null) {
                for (Map.Entry<String, String> kvp : headers.entrySet()) {
                    conn.setRequestProperty(kvp.getKey(), kvp.getValue());
                }
            }
            if ((status = conn.getResponseCode()) != 200) {
                throw new IOException(String.format("%d %s", status, conn.getResponseMessage()));
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
            }
        }
        catch (IOException e) {
            throw new MongoInternalException("Unexpected IOException", e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return content.toString();
    }

    private AwsCredentialHelper() {
    }
}

