/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.utils;

import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceTableConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogTableUtils {
    private static final Logger log = LoggerFactory.getLogger(CatalogTableUtils.class);

    public static List<CatalogTable> mergeCatalogTableConfig(List<CatalogTable> tables, List<JdbcSourceTableConfig> tableConfigs, Function<String, TablePath> parser) {
        Map<TablePath, CatalogTable> catalogTableMap = tables.stream().collect(Collectors.toMap(t -> t.getTableId().toTablePath(), t -> t));
        for (JdbcSourceTableConfig catalogTableConfig : tableConfigs) {
            TablePath tablePath = parser.apply(catalogTableConfig.getTable());
            CatalogTable catalogTable = catalogTableMap.get(tablePath);
            if (catalogTable != null) {
                catalogTable = CatalogTableUtils.mergeCatalogTableConfig(catalogTable, catalogTableConfig);
                catalogTableMap.put(tablePath, catalogTable);
                log.info("Override primary key({}) for catalog table {}", catalogTableConfig.getPrimaryKeys(), (Object)catalogTableConfig.getTable());
                continue;
            }
            log.warn("Table {} is not found in catalog tables, skip to merge config", (Object)catalogTableConfig.getTable());
        }
        return new ArrayList<CatalogTable>(catalogTableMap.values());
    }

    public static CatalogTable mergeCatalogTableConfig(CatalogTable table, JdbcSourceTableConfig config) {
        List columnNames = table.getTableSchema().getColumns().stream().map(c -> c.getName()).collect(Collectors.toList());
        for (String pk : config.getPrimaryKeys()) {
            if (columnNames.contains(pk)) continue;
            throw new IllegalArgumentException(String.format("Primary key(%s) is not in table(%s) columns(%s)", pk, table.getTablePath(), columnNames));
        }
        PrimaryKey primaryKeys = PrimaryKey.of((String)("pk" + (config.getPrimaryKeys().hashCode() & Integer.MAX_VALUE)), config.getPrimaryKeys());
        List columns = table.getTableSchema().getColumns().stream().map(column -> {
            if (config.getPrimaryKeys().contains(column.getName()) && column.isNullable()) {
                log.warn("Primary key({}) is nullable for catalog table {}", (Object)column.getName(), (Object)table.getTablePath());
                return PhysicalColumn.of((String)column.getName(), (SeaTunnelDataType)column.getDataType(), (Long)column.getColumnLength(), (boolean)false, (Object)column.getDefaultValue(), (String)column.getComment());
            }
            return column;
        }).collect(Collectors.toList());
        return CatalogTable.of((TableIdentifier)table.getTableId(), (TableSchema)TableSchema.builder().primaryKey(primaryKeys).columns(columns).constraintKey(table.getTableSchema().getConstraintKeys()).build(), (Map)table.getOptions(), (List)table.getPartitionKeys(), (String)table.getComment());
    }

    public static Table mergeCatalogTableConfig(Table debeziumTable, CatalogTable catalogTable) {
        PrimaryKey pk = catalogTable.getTableSchema().getPrimaryKey();
        if (pk != null) {
            debeziumTable = debeziumTable.edit().setPrimaryKeyNames(pk.getColumnNames()).create();
            log.info("Override primary key({}) for catalog table {}", (Object)pk.getColumnNames(), (Object)debeziumTable.id());
        }
        return debeziumTable;
    }

    public static Map<TableId, CatalogTable> convertTables(List<CatalogTable> catalogTables) {
        Map<TableId, CatalogTable> tableMap = catalogTables.stream().collect(Collectors.toMap(e -> new TableId(e.getTableId().getDatabaseName(), e.getTableId().getSchemaName(), e.getTableId().getTableName()), e -> e));
        return Collections.unmodifiableMap(tableMap);
    }
}

