/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.relational.connection;

import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.relational.connection.ConnectionPoolId;
import org.apache.seatunnel.connectors.cdc.base.relational.connection.ConnectionPools;
import org.apache.seatunnel.connectors.cdc.base.relational.connection.JdbcConnectionPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionPools
implements ConnectionPools<HikariDataSource, JdbcSourceConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcConnectionPools.class);
    private static JdbcConnectionPools INSTANCE;
    private final Map<ConnectionPoolId, HikariDataSource> pools = new HashMap<ConnectionPoolId, HikariDataSource>();
    private static JdbcConnectionPoolFactory JDBCCONNECTIONPOOLFACTORY;

    private JdbcConnectionPools() {
    }

    public static synchronized JdbcConnectionPools getInstance(JdbcConnectionPoolFactory jdbcConnectionPoolFactory) {
        if (INSTANCE == null) {
            JDBCCONNECTIONPOOLFACTORY = jdbcConnectionPoolFactory;
            INSTANCE = new JdbcConnectionPools();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HikariDataSource getOrCreateConnectionPool(ConnectionPoolId poolId, JdbcSourceConfig sourceConfig) {
        Map<ConnectionPoolId, HikariDataSource> map = this.pools;
        synchronized (map) {
            if (!this.pools.containsKey(poolId)) {
                LOG.debug("Create and register connection pool {}", (Object)poolId);
                this.pools.put(poolId, JDBCCONNECTIONPOOLFACTORY.createPooledDataSource(sourceConfig));
            }
            return this.pools.get(poolId);
        }
    }
}

