/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.or.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.or.ObjectRenderer;

public class MessageRenderer
implements ObjectRenderer {
    public String doRender(Object o) {
        if (o instanceof Message) {
            StringBuilder sbuf = new StringBuilder();
            Message m3 = (Message)o;
            try {
                sbuf.append("DeliveryMode=");
                switch (m3.getJMSDeliveryMode()) {
                    case 1: {
                        sbuf.append("NON_PERSISTENT");
                        break;
                    }
                    case 2: {
                        sbuf.append("PERSISTENT");
                        break;
                    }
                    default: {
                        sbuf.append("UNKNOWN");
                    }
                }
                sbuf.append(", CorrelationID=");
                sbuf.append(m3.getJMSCorrelationID());
                sbuf.append(", Destination=");
                sbuf.append(m3.getJMSDestination());
                sbuf.append(", Expiration=");
                sbuf.append(m3.getJMSExpiration());
                sbuf.append(", MessageID=");
                sbuf.append(m3.getJMSMessageID());
                sbuf.append(", Priority=");
                sbuf.append(m3.getJMSPriority());
                sbuf.append(", Redelivered=");
                sbuf.append(m3.getJMSRedelivered());
                sbuf.append(", ReplyTo=");
                sbuf.append(m3.getJMSReplyTo());
                sbuf.append(", Timestamp=");
                sbuf.append(m3.getJMSTimestamp());
                sbuf.append(", Type=");
                sbuf.append(m3.getJMSType());
            }
            catch (JMSException e) {
                LogLog.error("Could not parse Message.", e);
            }
            return sbuf.toString();
        }
        return o.toString();
    }
}

