/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;

public class MongoDbEventMetadataProvider
implements EventMetadataProvider {
    @Override
    public Instant getEventTimestamp(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        if (sourceInfo.schema().field("sec") != null) {
            Integer timestamp = sourceInfo.getInt32("sec");
            return timestamp == null ? null : Instant.ofEpochSecond(timestamp.intValue());
        }
        Long timestamp = sourceInfo.getInt64("ts_ms");
        return timestamp == null ? null : Instant.ofEpochMilli(timestamp);
    }

    @Override
    public Map<String, String> getEventSourcePosition(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        Integer ord = sourceInfo.getInt32("ord");
        return Collect.hashMapOf("ord", Integer.toString(ord));
    }

    @Override
    public String getTransactionId(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        String sessionTxnId;
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        if (sourceInfo.schema().field("stxnid") != null && (sessionTxnId = sourceInfo.getString("stxnid")) != null) {
            return sessionTxnId;
        }
        if (sourceInfo.schema().field("lsid") != null && (sourceInfo.getString("lsid") != null || sourceInfo.getInt64("txnNumber") != null)) {
            String lsid = sourceInfo.getString("lsid");
            Long txnNumber = sourceInfo.getInt64("txnNumber");
            if (lsid == null) {
                return txnNumber.toString();
            }
            if (txnNumber == null) {
                return lsid;
            }
            return lsid + ":" + txnNumber;
        }
        Long operationId = sourceInfo.getInt64("h");
        if (operationId == null) {
            return null;
        }
        return Long.toString(operationId);
    }
}

