/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.LegacyV1AbstractSourceInfoStructMaker;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.util.SchemaNameAdjuster;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class LegacyV1MongoDbSourceInfoStructMaker
extends LegacyV1AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema = this.commonSchemaBuilder().name(SchemaNameAdjuster.avroAdjuster().adjust("io.debezium.connector.mongo.Source")).version(1).field("name", Schema.STRING_SCHEMA).field("rs", Schema.STRING_SCHEMA).field("ns", Schema.STRING_SCHEMA).field("sec", Schema.INT32_SCHEMA).field("ord", Schema.INT32_SCHEMA).field("h", Schema.OPTIONAL_INT64_SCHEMA).field("initsync", SchemaBuilder.bool().optional().defaultValue(false).build()).build();
    private final String serverName;

    public LegacyV1MongoDbSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
        this.serverName = connectorConfig.getLogicalName();
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public Struct struct(SourceInfo sourceInfo) {
        Struct result = super.commonStruct().put("name", (Object)this.serverName).put("rs", (Object)sourceInfo.replicaSetName()).put("ns", (Object)sourceInfo.collectionId().namespace()).put("sec", (Object)sourceInfo.position().getTime()).put("ord", (Object)sourceInfo.position().getInc()).put("h", (Object)sourceInfo.position().getOperationId());
        if (sourceInfo.isInitialSyncOngoing(sourceInfo.replicaSetName())) {
            result.put("initsync", (Object)true);
        }
        return result;
    }
}

