/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public final class BsonDocumentFieldLookup {
    public static Optional<BsonValue> fieldLookup(String fieldPath, BsonDocument document) {
        if (document.containsKey(fieldPath)) {
            return Optional.of(document.get(fieldPath));
        }
        if (fieldPath.contains(".") && !fieldPath.endsWith(".")) {
            String subDocumentName = fieldPath.substring(0, fieldPath.indexOf("."));
            String subDocumentFieldName = fieldPath.substring(fieldPath.indexOf(".") + 1);
            if (document.isDocument(subDocumentName)) {
                return BsonDocumentFieldLookup.fieldLookup(subDocumentFieldName, document.getDocument(subDocumentName));
            }
        }
        return Optional.empty();
    }

    private BsonDocumentFieldLookup() {
    }
}

