/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.field.renaming;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.processor.field.renaming.RegExpSettings;
import com.mongodb.kafka.connect.sink.processor.field.renaming.Renamer;
import com.mongodb.kafka.connect.util.ConfigHelper;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public class RenameByRegExp
extends Renamer {
    private final List<RegExpSettings> regExpSettings = this.parseRenameRegExpSettings();

    public RenameByRegExp(MongoSinkTopicConfig config) {
        super(config);
    }

    @Override
    boolean isActive() {
        return !this.regExpSettings.isEmpty();
    }

    @Override
    String renamed(String path, String name) {
        String newName = name;
        for (RegExpSettings regExpSetting : this.regExpSettings) {
            if (!(path + "." + name).matches(regExpSetting.getRegexp())) continue;
            newName = newName.replaceAll(regExpSetting.getPattern(), regExpSetting.getReplace());
        }
        return newName;
    }

    private List<RegExpSettings> parseRenameRegExpSettings() {
        String settings = this.getConfig().getString("field.renamer.regexp");
        ArrayList<RegExpSettings> regExpSettings = new ArrayList<RegExpSettings>();
        ConfigHelper.jsonArrayFromString(settings).ifPresent(r -> r.forEach(d -> regExpSettings.add(new RegExpSettings((Document)d))));
        return regExpSettings;
    }
}

