/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.namespace.mapping;

import com.mongodb.MongoNamespace;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.namespace.mapping.NamespaceMapper;
import com.mongodb.kafka.connect.util.BsonDocumentFieldLookup;
import com.mongodb.kafka.connect.util.ConnectConfigException;
import java.util.Optional;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class FieldPathNamespaceMapper
implements NamespaceMapper {
    private String defaultDatabaseName;
    private String defaultCollectionName;
    private String keyDatabaseFieldPath;
    private String valueDatabaseFieldPath;
    private String keyCollectionFieldPath;
    private String valueCollectionFieldPath;
    private boolean throwErrorIfInvalid;

    @Override
    public void configure(MongoSinkTopicConfig config) {
        this.defaultDatabaseName = config.getString("database");
        this.defaultCollectionName = config.getString("collection");
        if (this.defaultCollectionName.isEmpty()) {
            this.defaultCollectionName = config.getTopic();
        }
        this.throwErrorIfInvalid = config.getBoolean("namespace.mapper.error.if.invalid");
        this.keyDatabaseFieldPath = config.getString("namespace.mapper.key.database.field");
        this.valueDatabaseFieldPath = config.getString("namespace.mapper.value.database.field");
        this.keyCollectionFieldPath = config.getString("namespace.mapper.key.collection.field");
        this.valueCollectionFieldPath = config.getString("namespace.mapper.value.collection.field");
        if (this.keyDatabaseFieldPath.isEmpty() && this.valueDatabaseFieldPath.isEmpty() && this.keyCollectionFieldPath.isEmpty() && this.valueCollectionFieldPath.isEmpty()) {
            throw new ConnectConfigException("namespace.mapper", config.getString("namespace.mapper"), "Missing configuration for the FieldBasedNamespaceMapper. Please configure the database and / or collection field path.");
        }
        if (!this.keyDatabaseFieldPath.isEmpty() && !this.valueDatabaseFieldPath.isEmpty()) {
            throw new ConnectConfigException("namespace.mapper.key.database.field", this.keyDatabaseFieldPath, String.format("Cannot set both: '%s' and '%s'", "namespace.mapper.key.database.field", "namespace.mapper.value.database.field"));
        }
        if (!this.keyCollectionFieldPath.isEmpty() && !this.valueCollectionFieldPath.isEmpty()) {
            throw new ConnectConfigException("namespace.mapper.key.collection.field", this.keyCollectionFieldPath, String.format("Cannot set both: '%s' and '%s'", "namespace.mapper.key.collection.field", "namespace.mapper.value.collection.field"));
        }
    }

    @Override
    public MongoNamespace getNamespace(SinkRecord sinkRecord, SinkDocument sinkDocument) {
        String databaseName = this.defaultDatabaseName;
        String collectionName = this.defaultCollectionName;
        if (!this.keyDatabaseFieldPath.isEmpty()) {
            databaseName = this.pathLookup(sinkRecord, sinkDocument, this.keyDatabaseFieldPath, true, databaseName);
        } else if (!this.valueDatabaseFieldPath.isEmpty()) {
            databaseName = this.pathLookup(sinkRecord, sinkDocument, this.valueDatabaseFieldPath, false, databaseName);
        }
        if (!this.keyCollectionFieldPath.isEmpty()) {
            collectionName = this.pathLookup(sinkRecord, sinkDocument, this.keyCollectionFieldPath, true, collectionName);
        } else if (!this.valueCollectionFieldPath.isEmpty()) {
            collectionName = this.pathLookup(sinkRecord, sinkDocument, this.valueCollectionFieldPath, false, collectionName);
        }
        return new MongoNamespace(databaseName, collectionName);
    }

    private String pathLookup(SinkRecord sinkRecord, SinkDocument sinkDocument, String path, boolean isKey, String defaultValue) {
        BsonValue fieldValue;
        BsonDocument data;
        Optional<BsonValue> optionalFieldValue;
        Optional<BsonDocument> optionalData;
        Optional<BsonDocument> optional = optionalData = isKey ? sinkDocument.getKeyDoc() : sinkDocument.getValueDoc();
        if (this.continueProcessing(optionalData.isPresent()) && this.continueProcessing((optionalFieldValue = BsonDocumentFieldLookup.fieldLookup(path, data = optionalData.orElseThrow(() -> new DataException(String.format("Invalid %s document: %s", isKey ? "key" : "value", sinkRecord))))).isPresent()) && this.continueProcessing((fieldValue = optionalFieldValue.orElseThrow(() -> new DataException(String.format("Missing document path '%s': %s", path, data.toJson())))).isString())) {
            if (!fieldValue.isString()) {
                throw new DataException(String.format("Invalid type for %s field path '%s', expected a String: %s", new Object[]{fieldValue.getBsonType(), path, data.toJson()}));
            }
            return fieldValue.asString().getValue();
        }
        return defaultValue;
    }

    private boolean continueProcessing(boolean canContinue) {
        return canContinue || this.throwErrorIfInvalid;
    }
}

