/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.dlq;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.WriteError;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.kafka.connect.sink.dlq.ErrorReporter;
import com.mongodb.kafka.connect.sink.dlq.WriteConcernException;
import com.mongodb.kafka.connect.sink.dlq.WriteException;
import com.mongodb.kafka.connect.sink.dlq.WriteSkippedException;
import com.mongodb.kafka.connect.util.Assertions;
import com.mongodb.lang.Nullable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.kafka.connect.sink.SinkRecord;

public final class AnalyzedBatchFailedWithBulkWriteException {
    private final List<SinkRecord> batch;
    private final MongoBulkWriteException e;
    private final ErrorReporter errorReporter;
    private final Logger logger;
    private final Map<Integer, Map.Entry<SinkRecord, WriteException>> recordsFailedWithWriteError = new HashMap<Integer, Map.Entry<SinkRecord, WriteException>>();
    private final Map<Integer, SinkRecord> recordsFailedWithWriteConcernError = new HashMap<Integer, SinkRecord>();
    private final Map<Integer, SinkRecord> skippedRecords = new HashMap<Integer, SinkRecord>();
    @Nullable
    private final WriteConcernException writeConcernException;
    private final WriteSkippedException writeSkippedException = new WriteSkippedException();

    public AnalyzedBatchFailedWithBulkWriteException(List<SinkRecord> batch, boolean ordered, MongoBulkWriteException e, ErrorReporter errorReporter, Logger logger) {
        this.batch = batch;
        this.e = e;
        this.errorReporter = errorReporter;
        this.logger = logger;
        WriteConcernError writeConcernError = e.getWriteConcernError();
        this.writeConcernException = writeConcernError == null ? null : new WriteConcernException(writeConcernError);
        this.analyze(ordered);
    }

    private void analyze(boolean ordered) {
        List<BulkWriteError> writeErrors = this.e.getWriteErrors();
        WriteConcernError writeConcernError = this.e.getWriteConcernError();
        Assertions.assertTrue(!writeErrors.isEmpty() || writeConcernError != null);
        writeErrors.forEach(writeError -> {
            int writeErrorIdx = writeError.getIndex();
            this.recordsFailedWithWriteError.put(writeErrorIdx, new AbstractMap.SimpleImmutableEntry<SinkRecord, WriteException>(this.batch.get(writeErrorIdx), new WriteException((WriteError)writeError)));
        });
        if (ordered && !writeErrors.isEmpty()) {
            Assertions.assertTrue(writeErrors.size() == 1);
            int writeErrorIdx = writeErrors.get(0).getIndex();
            for (int i2 = writeErrorIdx + 1; i2 < this.batch.size(); ++i2) {
                this.skippedRecords.put(i2, this.batch.get(i2));
            }
        }
        if (writeConcernError != null) {
            IntStream.range(0, this.batch.size()).filter(i -> !this.recordsFailedWithWriteError.containsKey(i) && !this.skippedRecords.containsKey(i)).forEach(i -> this.recordsFailedWithWriteConcernError.put(i, this.batch.get(i)));
        }
    }

    public void log() {
        if (!this.recordsFailedWithWriteError.isEmpty()) {
            this.recordsFailedWithWriteError.forEach((i, recordFailedWithWriteError) -> this.logger.log(Collections.singletonList((SinkRecord)recordFailedWithWriteError.getKey()), (RuntimeException)recordFailedWithWriteError.getValue()));
        }
        if (!this.recordsFailedWithWriteConcernError.isEmpty()) {
            this.logger.log(this.recordsFailedWithWriteConcernError.values(), Assertions.assertNotNull(this.writeConcernException));
        }
        if (!this.skippedRecords.isEmpty()) {
            this.logger.log(this.skippedRecords.values(), this.writeSkippedException);
        }
    }

    public void report() {
        for (int i = 0; i < this.batch.size(); ++i) {
            Map.Entry<SinkRecord, WriteException> recordFailedWithWriteError = this.recordsFailedWithWriteError.get(i);
            if (recordFailedWithWriteError != null) {
                this.errorReporter.report(recordFailedWithWriteError.getKey(), recordFailedWithWriteError.getValue());
                continue;
            }
            SinkRecord recordFailedWithWriteConcernError = this.recordsFailedWithWriteConcernError.get(i);
            if (recordFailedWithWriteConcernError != null) {
                this.errorReporter.report(recordFailedWithWriteConcernError, Assertions.assertNotNull(this.writeConcernException));
                continue;
            }
            SinkRecord skippedRecord = this.skippedRecords.get(i);
            if (skippedRecord == null) continue;
            this.errorReporter.report(skippedRecord, this.writeSkippedException);
        }
    }

    public static interface Logger {
        public void log(Collection<SinkRecord> var1, RuntimeException var2);
    }
}

