/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.relational.connection;

import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.relational.connection.ConnectionPoolId;
import org.apache.seatunnel.connectors.cdc.base.relational.connection.JdbcConnectionPoolFactory;
import org.apache.seatunnel.connectors.cdc.base.relational.connection.JdbcConnectionPools;
import org.apache.seatunnel.shade.com.zaxxer.hikari.HikariDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionFactory
implements JdbcConnection.ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcConnectionFactory.class);
    private final JdbcSourceConfig sourceConfig;
    private final JdbcConnectionPoolFactory jdbcConnectionPoolFactory;

    public JdbcConnectionFactory(JdbcSourceConfig sourceConfig, JdbcConnectionPoolFactory jdbcConnectionPoolFactory) {
        this.sourceConfig = sourceConfig;
        this.jdbcConnectionPoolFactory = jdbcConnectionPoolFactory;
    }

    public Connection connect(JdbcConfiguration config) throws SQLException {
        int connectRetryTimes = this.sourceConfig.getConnectMaxRetries();
        ConnectionPoolId connectionPoolId = new ConnectionPoolId(this.sourceConfig.getHostname(), this.sourceConfig.getPort(), this.sourceConfig.getUsername());
        HikariDataSource dataSource = JdbcConnectionPools.getInstance(this.jdbcConnectionPoolFactory).getOrCreateConnectionPool(connectionPoolId, this.sourceConfig);
        for (int i = 0; i < connectRetryTimes; ++i) {
            try {
                return dataSource.getConnection();
            }
            catch (SQLException e) {
                if (i < connectRetryTimes - 1) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException ie) {
                        throw new SeaTunnelException("Failed to get connection, interrupted while doing another attempt", (Throwable)ie);
                    }
                } else {
                    LOG.error("Get connection failed after retry {} times", (Object)(i + 1));
                    throw new SeaTunnelException((Throwable)e);
                }
                LOG.warn("Get connection failed, retry times {}", (Object)(i + 1));
                continue;
            }
        }
        return dataSource.getConnection();
    }
}

