/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.source.reader;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.cdc.base.config.SourceConfig;
import org.apache.seatunnel.connectors.cdc.base.dialect.DataSourceDialect;
import org.apache.seatunnel.connectors.cdc.base.schema.SchemaChangeResolver;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.FetchTask;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.Fetcher;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.IncrementalSourceScanFetcher;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.IncrementalSourceStreamFetcher;
import org.apache.seatunnel.connectors.cdc.base.source.split.ChangeEventRecords;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceRecords;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;
import org.apache.seatunnel.connectors.seatunnel.common.source.reader.RecordsWithSplitIds;
import org.apache.seatunnel.connectors.seatunnel.common.source.reader.splitreader.SplitReader;
import org.apache.seatunnel.connectors.seatunnel.common.source.reader.splitreader.SplitsAddition;
import org.apache.seatunnel.connectors.seatunnel.common.source.reader.splitreader.SplitsChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalSourceSplitReader<C extends SourceConfig>
implements SplitReader<SourceRecords, SourceSplitBase> {
    private static final Logger log = LoggerFactory.getLogger(IncrementalSourceSplitReader.class);
    private final Queue<SourceSplitBase> splits;
    private final int subtaskId;
    private Fetcher<SourceRecords, SourceSplitBase> currentFetcher;
    private String currentSplitId;
    private final DataSourceDialect<C> dataSourceDialect;
    private final C sourceConfig;
    private final SchemaChangeResolver schemaChangeResolver;

    public IncrementalSourceSplitReader(int subtaskId, DataSourceDialect<C> dataSourceDialect, C sourceConfig, SchemaChangeResolver schemaChangeResolver) {
        this.subtaskId = subtaskId;
        this.splits = new ArrayDeque<SourceSplitBase>();
        this.dataSourceDialect = dataSourceDialect;
        this.sourceConfig = sourceConfig;
        this.schemaChangeResolver = schemaChangeResolver;
    }

    public RecordsWithSplitIds<SourceRecords> fetch() throws IOException {
        this.checkSplitOrStartNext();
        this.checkNeedStopBinlogReader();
        Iterator<SourceRecords> dataIt = null;
        try {
            dataIt = this.currentFetcher.pollSplitRecords();
        }
        catch (InterruptedException | SeaTunnelException e) {
            log.warn("fetch data failed.", e);
            throw new IOException(e);
        }
        return dataIt == null ? this.finishedSnapshotSplit() : ChangeEventRecords.forRecords(this.currentSplitId, dataIt);
    }

    public void handleSplitsChanges(SplitsChange<SourceSplitBase> splitsChanges) {
        if (!(splitsChanges instanceof SplitsAddition)) {
            throw new UnsupportedOperationException(String.format("The SplitChange type of %s is not supported.", splitsChanges.getClass()));
        }
        log.debug("Handling split change {}", splitsChanges);
        this.splits.addAll(splitsChanges.splits());
    }

    public void wakeUp() {
    }

    public void close() throws Exception {
        if (this.currentFetcher != null) {
            log.info("Close current fetcher {}", (Object)this.currentFetcher.getClass().getCanonicalName());
            this.currentFetcher.close();
            this.currentSplitId = null;
        }
    }

    private void checkNeedStopBinlogReader() {
    }

    protected void checkSplitOrStartNext() throws IOException {
        if (this.currentFetcher instanceof IncrementalSourceStreamFetcher) {
            return;
        }
        if (this.canAssignNextSplit()) {
            SourceSplitBase nextSplit = this.splits.poll();
            if (nextSplit == null) {
                throw new IOException("Cannot fetch from another split - no split remaining.");
            }
            this.currentSplitId = nextSplit.splitId();
            if (nextSplit.isSnapshotSplit()) {
                if (this.currentFetcher == null) {
                    FetchTask.Context taskContext = this.dataSourceDialect.createFetchTaskContext(nextSplit, this.sourceConfig);
                    this.currentFetcher = new IncrementalSourceScanFetcher(taskContext, this.subtaskId);
                }
            } else {
                if (this.currentFetcher != null) {
                    log.info("It's turn to read incremental split, close current snapshot fetcher.");
                    this.currentFetcher.close();
                }
                FetchTask.Context taskContext = this.dataSourceDialect.createFetchTaskContext(nextSplit, this.sourceConfig);
                this.currentFetcher = new IncrementalSourceStreamFetcher(taskContext, this.subtaskId, this.schemaChangeResolver);
                log.info("Stream fetcher is created.");
            }
            this.currentFetcher.submitTask(this.dataSourceDialect.createFetchTask(nextSplit));
        }
    }

    public boolean canAssignNextSplit() {
        return this.currentFetcher == null || this.currentFetcher.isFinished();
    }

    private ChangeEventRecords finishedSnapshotSplit() {
        ChangeEventRecords finishedRecords = ChangeEventRecords.forFinishedSplit(this.currentSplitId);
        this.currentSplitId = null;
        return finishedRecords;
    }
}

